/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.List;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.analyzer.NiFiS2S;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.flowfile.attributes.SiteToSiteAttributes;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRemotePort
extends NiFiS2S {
    private static final Logger logger = LoggerFactory.getLogger(NiFiRemotePort.class);

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        List<ConnectionStatus> connections;
        if (!ProvenanceEventType.SEND.equals((Object)event.getEventType()) && !ProvenanceEventType.RECEIVE.equals((Object)event.getEventType())) {
            return null;
        }
        boolean isRemoteInputPort = event.getComponentType().equals("Remote Input Port");
        String type = isRemoteInputPort ? "nifi_input_port" : "nifi_output_port";
        NiFiS2S.S2SPort s2SPort = this.analyzeS2SPort(event, context.getNamespaceResolver());
        String componentId = event.getComponentId();
        List<ConnectionStatus> list = connections = isRemoteInputPort ? context.findConnectionTo(componentId) : context.findConnectionFrom(componentId);
        if (connections == null || connections.isEmpty()) {
            logger.warn("Connection was not found: {}", new Object[]{event});
            return null;
        }
        ConnectionStatus connection = connections.get(0);
        Referenceable ref = new Referenceable(type, new String[0]);
        ref.set("name", (Object)(isRemoteInputPort ? connection.getDestinationName() : connection.getSourceName()));
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(s2SPort.namespace, s2SPort.targetPortId));
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref);
    }

    @Override
    public String targetComponentTypePattern() {
        return "^Remote (In|Out)put Port$";
    }

    @Override
    protected String getRawProtocolPortId(ProvenanceEventRecord event) {
        return event.getAttribute(SiteToSiteAttributes.S2S_PORT_ID.key());
    }
}

