/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTopic
extends AbstractNiFiProvenanceEventAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaTopic.class);
    private static final String TYPE = "kafka_topic";
    private static final String ATTR_TOPIC = "topic";
    private static final Pattern URI_PATTERN = Pattern.compile("^.+://([^/]+)/(.+)$");

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        Referenceable ref = new Referenceable(TYPE, new String[0]);
        String transitUri = event.getTransitUri();
        if (transitUri == null) {
            return null;
        }
        Matcher uriMatcher = URI_PATTERN.matcher(transitUri);
        if (!uriMatcher.matches()) {
            logger.warn("Unexpected transit URI: {}", new Object[]{transitUri});
            return null;
        }
        String[] hostNames = this.splitHostNames(uriMatcher.group(1));
        String namespace = context.getNamespaceResolver().fromHostNames(hostNames);
        String topicName = uriMatcher.group(2);
        ref.set("name", (Object)topicName);
        ref.set(ATTR_TOPIC, (Object)topicName);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(namespace, topicName));
        ref.set("uri", (Object)transitUri);
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref);
    }

    @Override
    public String targetComponentTypePattern() {
        return "^(Publish|Consume)Kafka.*$";
    }
}

