/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.analyzer.AbstractHiveAnalyzer;
import org.apache.nifi.atlas.provenance.analyzer.DatabaseAnalyzerUtil;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive2JDBC
extends AbstractHiveAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(Hive2JDBC.class);
    private static final String URI_PATTERN_STR = "jdbc:hive2://([^/]+)/?(.*)$";
    private static final Pattern URI_PATTERN = Pattern.compile("jdbc:hive2://([^/]+)/?(.*)$");
    private static final String UNKNOWN_TABLE = "unknown";

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String transitUri = event.getTransitUri();
        if (transitUri == null) {
            return null;
        }
        Matcher uriMatcher = URI_PATTERN.matcher(transitUri);
        if (!uriMatcher.matches()) {
            logger.warn("Unexpected transit URI: {}", (Object)transitUri);
            return null;
        }
        String namespace = context.getNamespaceResolver().fromHostNames(this.splitHostNames(uriMatcher.group(1)));
        String connectedDatabaseName = null;
        if (uriMatcher.groupCount() > 1) {
            String[] connectionParams = uriMatcher.group(2).split(";");
            connectedDatabaseName = connectionParams[0];
        }
        if (StringUtils.isEmpty(connectedDatabaseName)) {
            connectedDatabaseName = "default";
        }
        Set<Tuple<String, String>> inputTables = DatabaseAnalyzerUtil.parseTableNames(connectedDatabaseName, event.getAttribute(DatabaseAnalyzerUtil.ATTR_INPUT_TABLES));
        Set<Tuple<String, String>> outputTables = DatabaseAnalyzerUtil.parseTableNames(connectedDatabaseName, event.getAttribute(DatabaseAnalyzerUtil.ATTR_OUTPUT_TABLES));
        if (inputTables.isEmpty() && outputTables.isEmpty()) {
            ProvenanceEventType eventType = event.getEventType();
            if (eventType == ProvenanceEventType.RECEIVE || eventType == ProvenanceEventType.FETCH) {
                logger.warn("Input table name is missing, defaults to '{}'. Transit URI: {}", (Object)UNKNOWN_TABLE, (Object)transitUri);
                inputTables = Collections.singleton(new Tuple((Object)connectedDatabaseName.toLowerCase(), (Object)UNKNOWN_TABLE));
            } else if (eventType == ProvenanceEventType.SEND) {
                logger.warn("Output table name is missing, defaults to '{}'. Transit URI: {}", (Object)UNKNOWN_TABLE, (Object)transitUri);
                outputTables = Collections.singleton(new Tuple((Object)connectedDatabaseName.toLowerCase(), (Object)UNKNOWN_TABLE));
            }
        }
        DataSetRefs refs = new DataSetRefs(event.getComponentId());
        this.addRefs(refs, true, namespace, inputTables);
        this.addRefs(refs, false, namespace, outputTables);
        return refs;
    }

    private void addRefs(DataSetRefs refs, boolean isInput, String namespace, Set<Tuple<String, String>> tableNames) {
        tableNames.forEach(tableName -> {
            Referenceable ref = this.createTableRef(namespace, (Tuple<String, String>)tableName);
            if (isInput) {
                refs.addInput(ref);
            } else {
                refs.addOutput(ref);
            }
        });
    }

    @Override
    public String targetTransitUriPattern() {
        return URI_PATTERN_STR;
    }
}

