/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTable
extends AbstractNiFiProvenanceEventAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(HBaseTable.class);
    static final String TYPE_HBASE_TABLE = "hbase_table";
    static final String TYPE_HBASE_NAMESPACE = "hbase_namespace";
    static final String ATTR_NAMESPACE = "namespace";
    static final String DEFAULT_NAMESPACE = "default";
    private static final Pattern URI_PATTERN = Pattern.compile("^hbase://([^/]+)/(([^/]+):)?([^/]+)/?.*$");

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String transitUri = event.getTransitUri();
        Matcher uriMatcher = URI_PATTERN.matcher(transitUri);
        if (!uriMatcher.matches()) {
            logger.warn("Unexpected transit URI: {}", (Object)transitUri);
            return null;
        }
        String[] hostNames = this.splitHostNames(uriMatcher.group(1));
        String namespace = context.getNamespaceResolver().fromHostNames(hostNames);
        String hbaseNamespaceName = uriMatcher.group(3) != null ? uriMatcher.group(3) : DEFAULT_NAMESPACE;
        String hbaseTableName = uriMatcher.group(4);
        Referenceable hbaseNamespaceRef = this.createHBaseNamespaceRef(namespace, hbaseNamespaceName);
        Referenceable hbaseTableRef = this.getHBaseTableRef(namespace, hbaseTableName, hbaseNamespaceRef);
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), hbaseTableRef);
    }

    @Override
    public String targetTransitUriPattern() {
        return "^hbase://.+$";
    }

    private Referenceable createHBaseNamespaceRef(String namespace, String hbaseNamespaceName) {
        Referenceable hbaseNamespaceRef = new Referenceable(TYPE_HBASE_NAMESPACE, new String[0]);
        hbaseNamespaceRef.set("name", (Object)hbaseNamespaceName);
        hbaseNamespaceRef.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(namespace, hbaseNamespaceName));
        hbaseNamespaceRef.set("clusterName", (Object)namespace);
        return hbaseNamespaceRef;
    }

    private Referenceable getHBaseTableRef(String namespace, String hbaseTableName, Referenceable hbaseNamespaceRef) {
        Referenceable hbaseTableRef = new Referenceable(TYPE_HBASE_TABLE, new String[0]);
        String hbaseTableFullName = String.format("%s:%s", hbaseNamespaceRef.get("name"), hbaseTableName);
        boolean isDefaultHBaseNamespace = DEFAULT_NAMESPACE.equals(hbaseNamespaceRef.get("name"));
        hbaseTableRef.set("name", (Object)(isDefaultHBaseNamespace ? hbaseTableName : hbaseTableFullName));
        hbaseTableRef.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(namespace, hbaseTableFullName));
        hbaseTableRef.set(ATTR_NAMESPACE, (Object)hbaseNamespaceRef);
        hbaseTableRef.set("uri", (Object)(isDefaultHBaseNamespace ? hbaseTableName : hbaseTableFullName));
        return hbaseTableRef;
    }
}

