/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.provenance.analyzer.AbstractDirectoryAnalyzer;

public class GCSDirectory
extends AbstractDirectoryAnalyzer {
    static final String GCP_STORAGE_VIRTUAL_DIRECTORY = "gcp_storage_virtual_directory";
    static final String REL_PARENT = "parent";

    @Override
    public String targetTransitUriPattern() {
        return "^gs://.+/.+$";
    }

    @Override
    protected Referenceable convertToReferenceable(AtlasEntity entity, Map<String, AtlasEntity> knownEntities) {
        AtlasObjectId parentId;
        if (entity == null) {
            return null;
        }
        Referenceable ref = this.createReferenceable(entity);
        if (GCP_STORAGE_VIRTUAL_DIRECTORY.equals(entity.getTypeName()) && (parentId = (AtlasObjectId)entity.getRelationshipAttribute(REL_PARENT)) != null) {
            AtlasEntity parentEntity = knownEntities.get(parentId.getUniqueAttributes().get("qualifiedName"));
            ref.set(REL_PARENT, (Object)this.convertToReferenceable(parentEntity, knownEntities));
        }
        return ref;
    }

    private Referenceable createReferenceable(AtlasEntity entity) {
        Referenceable ref = new Referenceable(entity.getTypeName(), new String[0]);
        ref.setValues(entity.getAttributes());
        return ref;
    }
}

