/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.analyzer.AbstractFileSystemPathAnalyzer;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePath
extends AbstractFileSystemPathAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePath.class);
    private static final String TYPE = "fs_path";

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String namespace;
        Referenceable ref = new Referenceable(TYPE, new String[0]);
        URI uri = this.parseUri(event.getTransitUri());
        try {
            String uriHost = uri.getHost();
            String hostname = StringUtils.isEmpty((CharSequence)uriHost) ? InetAddress.getLocalHost().getHostName() : uriHost;
            namespace = context.getNamespaceResolver().fromHostNames(hostname);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to get localhost name due to " + e, (Throwable)e);
            return null;
        }
        String path = this.getPath(context, uri);
        ref.set("name", (Object)path);
        ref.set("path", (Object)path);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(namespace, path));
        return this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref);
    }

    @Override
    public String targetTransitUriPattern() {
        return "^file:/.+$";
    }
}

