/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.utils.AtlasPathExtractorUtil;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.hadoop.fs.Path;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;

public class AzureADLSDirectory
extends AbstractNiFiProvenanceEventAnalyzer {
    public static final String TYPE_DIRECTORY = "adls_gen2_directory";
    public static final String TYPE_CONTAINER = "adls_gen2_container";
    public static final String TYPE_ACCOUNT = "adls_gen2_account";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_ACCOUNT = "account";

    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String transitUri = event.getTransitUri();
        if (transitUri == null) {
            return null;
        }
        Path path = new Path(transitUri);
        String namespace = context.getNamespaceResolver().fromHostNames(path.toUri().getHost());
        PathExtractorContext pathExtractorContext = new PathExtractorContext(namespace);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)pathExtractorContext);
        Referenceable fileRef = this.convertToReferenceable(entityWithExtInfo.getEntity(), pathExtractorContext.getKnownEntities());
        Referenceable parentRef = (Referenceable)fileRef.get(ATTR_PARENT);
        return parentRef != null ? this.singleDataSetRef(event.getComponentId(), event.getEventType(), parentRef) : null;
    }

    @Override
    public String targetTransitUriPattern() {
        return "^abfs(s)?://.+@.+/.+$";
    }

    private Referenceable convertToReferenceable(AtlasEntity entity, Map<String, AtlasEntity> knownEntities) {
        AtlasObjectId accountObjectId;
        if (entity == null) {
            return null;
        }
        Referenceable ref = new Referenceable(entity.getTypeName(), new String[0]);
        ref.set("qualifiedName", entity.getAttribute("qualifiedName"));
        ref.set("name", entity.getAttribute("name"));
        if (TYPE_DIRECTORY.equals(entity.getTypeName())) {
            AtlasObjectId parentObjectId = (AtlasObjectId)entity.getRelationshipAttribute(ATTR_PARENT);
            if (parentObjectId != null) {
                AtlasEntity parentEntity = knownEntities.get(parentObjectId.getUniqueAttributes().get("qualifiedName"));
                ref.set(ATTR_PARENT, (Object)this.convertToReferenceable(parentEntity, knownEntities));
            }
        } else if (TYPE_CONTAINER.equals(entity.getTypeName()) && (accountObjectId = (AtlasObjectId)entity.getRelationshipAttribute(ATTR_ACCOUNT)) != null) {
            AtlasEntity accountEntity = knownEntities.get(accountObjectId.getUniqueAttributes().get("qualifiedName"));
            ref.set(ATTR_ACCOUNT, (Object)this.convertToReferenceable(accountEntity, knownEntities));
        }
        return ref;
    }
}

