/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.provenance.analyzer.AbstractDirectoryAnalyzer;

public class AwsS3Directory
extends AbstractDirectoryAnalyzer {
    public static final String TYPE_DIRECTORY_V1 = "aws_s3_pseudo_dir";
    public static final String TYPE_BUCKET_V1 = "aws_s3_bucket";
    public static final String ATTR_BUCKET_V1 = "bucket";
    public static final String ATTR_OBJECT_PREFIX_V1 = "objectPrefix";
    public static final String TYPE_DIRECTORY_V2 = "aws_s3_v2_directory";
    public static final String TYPE_BUCKET_V2 = "aws_s3_v2_bucket";
    public static final String ATTR_CONTAINER_V2 = "container";
    public static final String ATTR_OBJECT_PREFIX_V2 = "objectPrefix";

    @Override
    public String targetTransitUriPattern() {
        return "^s3a://.+/.+$";
    }

    @Override
    protected Referenceable convertToReferenceable(AtlasEntity entity, Map<String, AtlasEntity> knownEntities) {
        AtlasObjectId containerObjectId;
        if (entity == null) {
            return null;
        }
        Referenceable ref = this.createReferenceable(entity);
        if (TYPE_DIRECTORY_V1.equals(entity.getTypeName())) {
            AtlasObjectId bucketObjectId = (AtlasObjectId)entity.getRelationshipAttribute(ATTR_BUCKET_V1);
            if (bucketObjectId != null) {
                AtlasEntity bucketEntity = knownEntities.get(bucketObjectId.getUniqueAttributes().get("qualifiedName"));
                ref.set(ATTR_BUCKET_V1, (Object)this.convertToReferenceable(bucketEntity, knownEntities));
            }
        } else if (TYPE_DIRECTORY_V2.equals(entity.getTypeName()) && (containerObjectId = (AtlasObjectId)entity.getRelationshipAttribute(ATTR_CONTAINER_V2)) != null) {
            AtlasEntity containerEntity = knownEntities.get(containerObjectId.getUniqueAttributes().get("qualifiedName"));
            ref.set(ATTR_CONTAINER_V2, (Object)this.convertToReferenceable(containerEntity, knownEntities));
        }
        return ref;
    }

    private Referenceable createReferenceable(AtlasEntity entity) {
        Referenceable ref = new Referenceable(entity.getTypeName(), new String[0]);
        ref.setValues(entity.getAttributes());
        return ref;
    }
}

