/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.analyzer.DatabaseAnalyzerUtil;
import org.apache.nifi.util.Tuple;

public abstract class AbstractHiveAnalyzer
extends AbstractNiFiProvenanceEventAnalyzer {
    static final String TYPE_DATABASE = "hive_db";
    static final String TYPE_TABLE = "hive_table";
    static final String ATTR_DB = "db";

    protected Referenceable createDatabaseRef(String namespace, String databaseName) {
        Referenceable ref = new Referenceable(TYPE_DATABASE, new String[0]);
        ref.set("name", (Object)databaseName);
        ref.set("clusterName", (Object)namespace);
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(namespace, databaseName));
        return ref;
    }

    protected Referenceable createTableRef(String namespace, Tuple<String, String> tableName) {
        Referenceable ref = new Referenceable(TYPE_TABLE, new String[0]);
        ref.set("name", tableName.getValue());
        ref.set("qualifiedName", (Object)AtlasUtils.toQualifiedName(namespace, DatabaseAnalyzerUtil.toTableNameStr(tableName)));
        ref.set(ATTR_DB, (Object)this.createDatabaseRef(namespace, (String)tableName.getKey()));
        return ref;
    }
}

