/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance.analyzer;

import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.utils.AtlasPathExtractorUtil;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.hadoop.fs.Path;
import org.apache.nifi.atlas.provenance.AbstractNiFiProvenanceEventAnalyzer;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.provenance.ProvenanceEventRecord;

public abstract class AbstractDirectoryAnalyzer
extends AbstractNiFiProvenanceEventAnalyzer {
    @Override
    public DataSetRefs analyze(AnalysisContext context, ProvenanceEventRecord event) {
        String transitUri = event.getTransitUri();
        if (transitUri == null) {
            return null;
        }
        String directoryUri = transitUri.substring(0, transitUri.lastIndexOf(47) + 1);
        Path path = new Path(directoryUri);
        String namespace = context.getNamespaceResolver().fromHostNames(path.toUri().getHost());
        PathExtractorContext pathExtractorContext = new PathExtractorContext(namespace, context.getAwsS3ModelVersion());
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)pathExtractorContext);
        Referenceable ref = this.convertToReferenceable(entityWithExtInfo.getEntity(), pathExtractorContext.getKnownEntities());
        return ref != null ? this.singleDataSetRef(event.getComponentId(), event.getEventType(), ref) : null;
    }

    protected abstract Referenceable convertToReferenceable(AtlasEntity var1, Map<String, AtlasEntity> var2);
}

