/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.atlas.NiFiFlow;
import org.apache.nifi.atlas.provenance.AnalysisContext;
import org.apache.nifi.atlas.provenance.FilesystemPathsLevel;
import org.apache.nifi.atlas.resolver.NamespaceResolver;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.lineage.ComputeLineageResult;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAnalysisContext
implements AnalysisContext {
    private final Logger logger = LoggerFactory.getLogger(StandardAnalysisContext.class);
    private final NiFiFlow nifiFlow;
    private final NamespaceResolver namespaceResolver;
    private final ProvenanceRepository provenanceRepository;
    private final String awsS3ModelVersion;
    private final FilesystemPathsLevel filesystemPathsLevel;

    public StandardAnalysisContext(NiFiFlow nifiFlow, NamespaceResolver namespaceResolver, ProvenanceRepository provenanceRepository, String awsS3ModelVersion, FilesystemPathsLevel filesystemPathsLevel) {
        this.nifiFlow = nifiFlow;
        this.namespaceResolver = namespaceResolver;
        this.provenanceRepository = provenanceRepository;
        this.awsS3ModelVersion = awsS3ModelVersion;
        this.filesystemPathsLevel = filesystemPathsLevel;
    }

    @Override
    public List<ConnectionStatus> findConnectionTo(String componentId) {
        return this.nifiFlow.getIncomingConnections(componentId);
    }

    @Override
    public List<ConnectionStatus> findConnectionFrom(String componentId) {
        return this.nifiFlow.getOutgoingConnections(componentId);
    }

    @Override
    public String getNiFiNamespace() {
        return this.nifiFlow.getNamespace();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComputeLineageResult getLineageResult(long eventId, ComputeLineageSubmission submission) {
        ComputeLineageResult result = submission.getResult();
        try {
            if (result.awaitCompletion(10L, TimeUnit.SECONDS)) {
                ComputeLineageResult computeLineageResult = result;
                return computeLineageResult;
            }
            this.logger.warn("Lineage query for {} timed out.", new Object[]{eventId});
        }
        catch (InterruptedException e) {
            this.logger.warn("Lineage query for {} was interrupted due to {}.", (Object)new Object[]{eventId, e}, (Object)e);
        }
        finally {
            submission.cancel();
        }
        return null;
    }

    @Override
    public ComputeLineageResult queryLineage(long eventId) {
        ComputeLineageSubmission submission = this.provenanceRepository.submitLineageComputation(eventId, null);
        return this.getLineageResult(eventId, submission);
    }

    @Override
    public ComputeLineageResult findParents(long eventId) {
        ComputeLineageSubmission submission = this.provenanceRepository.submitExpandParents(eventId, null);
        return this.getLineageResult(eventId, submission);
    }

    @Override
    public ProvenanceEventRecord getProvenanceEvent(long eventId) {
        try {
            return this.provenanceRepository.getEvent(eventId);
        }
        catch (IOException e) {
            this.logger.error("Failed to get provenance event for {} due to {}", (Object)new Object[]{eventId, e}, (Object)e);
            return null;
        }
    }

    @Override
    public String getAwsS3ModelVersion() {
        return this.awsS3ModelVersion;
    }

    @Override
    public FilesystemPathsLevel getFilesystemPathsLevel() {
        return this.filesystemPathsLevel;
    }
}

