/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.provenance;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.nifi.atlas.provenance.DataSetRefs;
import org.apache.nifi.atlas.provenance.NiFiProvenanceEventAnalyzer;
import org.apache.nifi.provenance.ProvenanceEventType;

public abstract class AbstractNiFiProvenanceEventAnalyzer
implements NiFiProvenanceEventAnalyzer {
    protected URI parseUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Failed to parse uri %s due to %s", uri, e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected URL parseUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            String msg = String.format("Failed to parse url %s due to %s", url, e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected DataSetRefs singleDataSetRef(String componentId, ProvenanceEventType eventType, Referenceable ref) {
        DataSetRefs refs = new DataSetRefs(componentId);
        switch (eventType) {
            case SEND: 
            case REMOTE_INVOCATION: {
                refs.addOutput(ref);
                break;
            }
            case FETCH: 
            case RECEIVE: {
                refs.addInput(ref);
            }
        }
        return refs;
    }

    protected String[] splitHostNames(String hostNames) {
        return (String[])Arrays.stream(hostNames.split(",")).map(hostName -> hostName.split(":")[0].trim()).toArray(String[]::new);
    }
}

