/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas.hook;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.nifi.atlas.NiFiAtlasClient;
import org.apache.nifi.atlas.hook.NotificationSender;
import org.apache.nifi.atlas.provenance.lineage.LineageContext;

public class NiFiAtlasHook
extends AtlasHook
implements LineageContext {
    public static final String NIFI_USER = "nifi";
    public static final String NIFI_SOURCE = "nifi";
    private NiFiAtlasClient atlasClient;
    private final List<HookNotification> messages = new ArrayList<HookNotification>();

    public void setAtlasClient(NiFiAtlasClient atlasClient) {
        this.atlasClient = atlasClient;
    }

    @Override
    public void addMessage(HookNotification message) {
        this.messages.add(message);
    }

    public String getMessageSource() {
        return "nifi";
    }

    public void commitMessages() {
        NotificationSender notificationSender = this.createNotificationSender();
        notificationSender.setAtlasClient(this.atlasClient);
        ArrayList<HookNotification> messagesBatch = new ArrayList<HookNotification>(this.messages);
        this.messages.clear();
        notificationSender.send(messagesBatch, (arg_0, arg_1) -> ((NiFiAtlasHook)this).notifyEntities(arg_0, arg_1));
    }

    public void close() {
        if (notificationInterface != null) {
            notificationInterface.close();
        }
    }

    NotificationSender createNotificationSender() {
        return new NotificationSender();
    }

    List<HookNotification> getMessages() {
        return this.messages;
    }
}

