/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.nifi.atlas.AtlasProcess;
import org.apache.nifi.atlas.AtlasUtils;
import org.apache.nifi.atlas.NiFiFlow;

public class NiFiFlowPath
implements AtlasProcess {
    private final List<String> processComponentIds = new ArrayList<String>();
    private final String id;
    private final Set<AtlasObjectId> inputs = new HashSet<AtlasObjectId>();
    private final Set<AtlasObjectId> outputs = new HashSet<AtlasObjectId>();
    private String atlasGuid;
    private String name;
    private String groupId;
    private AtlasEntity exEntity;
    private AtomicBoolean metadataUpdated = new AtomicBoolean(false);
    private List<String> updateAudit = new ArrayList<String>();
    private Set<String> existingInputGuids;
    private Set<String> existingOutputGuids;

    public NiFiFlowPath(String id) {
        this.id = id;
    }

    public NiFiFlowPath(String id, long lineageHash) {
        this.id = id + "::" + lineageHash;
    }

    public AtlasEntity getExEntity() {
        return this.exEntity;
    }

    public void setExEntity(AtlasEntity exEntity) {
        this.exEntity = exEntity;
        this.atlasGuid = exEntity.getGuid();
    }

    public String getAtlasGuid() {
        return this.atlasGuid;
    }

    public void setAtlasGuid(String atlasGuid) {
        this.atlasGuid = atlasGuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        AtlasUtils.updateMetadata(this.metadataUpdated, this.updateAudit, "name", this.name, name);
        this.name = name;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        AtlasUtils.updateMetadata(this.metadataUpdated, this.updateAudit, "groupId", this.groupId, groupId);
        this.groupId = groupId;
    }

    public void addProcessor(String processorId) {
        this.processComponentIds.add(processorId);
    }

    @Override
    public Set<AtlasObjectId> getInputs() {
        return this.inputs;
    }

    @Override
    public Set<AtlasObjectId> getOutputs() {
        return this.outputs;
    }

    public List<String> getProcessComponentIds() {
        return this.processComponentIds;
    }

    public String getId() {
        return this.id;
    }

    public String createDeepLinkURL(String nifiUrl) {
        String componentId = this.id.split("::")[0];
        return componentId.equals(this.groupId) ? String.format("%s?processGroupId=%s", nifiUrl, this.groupId) : String.format("%s?processGroupId=%s&componentIds=%s", nifiUrl, this.groupId, componentId);
    }

    public void startTrackingChanges(NiFiFlow nifiFlow) {
        this.metadataUpdated.set(false);
        this.updateAudit.clear();
        this.existingInputGuids = this.inputs.stream().map(AtlasObjectId::getGuid).collect(Collectors.toSet());
        this.existingOutputGuids = this.outputs.stream().map(AtlasObjectId::getGuid).collect(Collectors.toSet());
        Set<AtlasObjectId> ownedQueues = nifiFlow.getQueues().keySet();
        this.inputs.removeAll(ownedQueues);
        this.outputs.removeAll(ownedQueues);
    }

    public boolean isMetadataUpdated() {
        return this.metadataUpdated.get();
    }

    public List<String> getUpdateAudit() {
        return this.updateAudit;
    }

    boolean isDataSetReferenceChanged(Set<AtlasObjectId> ids, boolean isInput) {
        Set guids = ids.stream().map(AtlasObjectId::getGuid).collect(Collectors.toSet());
        Set<String> existingGuids = isInput ? this.existingInputGuids : this.existingOutputGuids;
        return existingGuids == null || !existingGuids.equals(guids);
    }

    public String toString() {
        return "NiFiFlowPath{name='" + this.name + '\'' + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", processComponentIds=" + this.processComponentIds + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NiFiFlowPath that = (NiFiFlowPath)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

