/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlas;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.atlas.model.instance.AtlasObjectId;

public class AtlasUtils {
    public static String toStr(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public static boolean isGuidAssigned(String guid) {
        return guid != null && !guid.startsWith("-");
    }

    public static String toQualifiedName(String namespace, String componentId) {
        return componentId + "@" + namespace;
    }

    public static String getComponentIdFromQualifiedName(String qualifiedName) {
        return qualifiedName.split("@")[0];
    }

    public static String getNamespaceFromQualifiedName(String qualifiedName) {
        return qualifiedName.split("@")[1];
    }

    public static String toTypedQualifiedName(String typeName, String qualifiedName) {
        return typeName + "::" + qualifiedName;
    }

    public static boolean isUpdated(Object current, Object arg) {
        if (current == null) {
            return arg != null;
        }
        return !current.equals(arg);
    }

    public static void updateMetadata(AtomicBoolean updatedTracker, List<String> updateAudit, String subject, Object currentValue, Object newValue) {
        if (AtlasUtils.isUpdated(currentValue, newValue)) {
            updatedTracker.set(true);
            updateAudit.add(String.format("%s changed from %s to %s", subject, currentValue, newValue));
        }
    }

    public static Optional<AtlasObjectId> findIdByQualifiedName(Set<AtlasObjectId> ids, String qualifiedName) {
        return ids.stream().filter(id -> qualifiedName.equals(id.getUniqueAttributes().get("qualifiedName"))).findFirst();
    }
}

