/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.transform;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.nemo.common.ir.OutputCollector;
import org.apache.nemo.common.ir.vertex.transform.NoWatermarkEmitTransform;
import org.apache.nemo.common.ir.vertex.transform.Transform;

public final class LocalTextFileTransform<I>
extends NoWatermarkEmitTransform<I, String> {
    private final String path;
    private String fileName;
    private List<I> elements;

    public LocalTextFileTransform(String path) {
        this.path = path;
    }

    public void prepare(Transform.Context context, OutputCollector<String> outputCollector) {
        this.fileName = this.path + UUID.randomUUID().toString();
        this.elements = new ArrayList<I>();
    }

    public void onData(I element) {
        this.elements.add(element);
    }

    public void close() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName, false), "utf-8"));){
            for (I element : this.elements) {
                writer.write(element + "\n");
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

