/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.nemo.common.ir.OutputCollector;
import org.apache.nemo.common.ir.vertex.transform.NoWatermarkEmitTransform;
import org.apache.nemo.common.ir.vertex.transform.Transform;

public final class HDFSTextFileTransform<I>
extends NoWatermarkEmitTransform<I, String> {
    private final String path;
    private transient Path fileName;
    private transient List<I> elements;

    public HDFSTextFileTransform(String path) {
        this.path = path;
    }

    public void prepare(Transform.Context context, OutputCollector<String> outputCollector) {
        this.fileName = new Path(this.path + UUID.randomUUID().toString());
        this.elements = new ArrayList<I>();
    }

    public void onData(I element) {
        this.elements.add(element);
    }

    public void close() {
        try (FileSystem fileSystem = this.fileName.getFileSystem((Configuration)new JobConf());
             FSDataOutputStream outputStream = fileSystem.create(this.fileName, false);){
            for (I element : this.elements) {
                outputStream.writeBytes(element + "\n");
            }
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

