/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.sql;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.naming.OperationNotSupportedException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nemo.client.JobLauncher;
import org.apache.nemo.compiler.frontend.spark.sql.DataFrameReader;
import org.apache.nemo.compiler.frontend.spark.sql.Dataset;
import org.apache.nemo.compiler.frontend.spark.sql.NemoSparkUserFacingClass;
import org.apache.nemo.conf.JobConf;
import org.apache.reef.tang.Configuration;
import org.apache.reef.tang.Injector;
import org.apache.reef.tang.Tang;
import org.apache.reef.tang.exceptions.InjectionException;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;

public final class SparkSession
extends org.apache.spark.sql.SparkSession
implements NemoSparkUserFacingClass,
Serializable {
    private final LinkedHashMap<String, Object[]> datasetCommandsList = new LinkedHashMap();
    private final Map<String, String> initialConf;
    private final AtomicBoolean isUserTriggered;

    private SparkSession(org.apache.nemo.compiler.frontend.spark.core.SparkContext sparkContext, Map<String, String> initialConf) {
        super((SparkContext)sparkContext);
        this.initialConf = initialConf;
        this.isUserTriggered = new AtomicBoolean(true);
    }

    @Override
    public boolean getIsUserTriggered() {
        return this.isUserTriggered.get();
    }

    @Override
    public void setIsUserTriggered(boolean isUserTriggered) {
        this.isUserTriggered.set(isUserTriggered);
    }

    @Override
    public SparkSession sparkSession() {
        return this;
    }

    void appendCommand(String cmd, Object ... args) {
        this.datasetCommandsList.put(cmd, args);
    }

    public LinkedHashMap<String, Object[]> getDatasetCommandsList() {
        return this.datasetCommandsList;
    }

    public Map<String, String> getInitialConf() {
        return this.initialConf;
    }

    public static <T> Dataset<T> initializeDataset(SparkSession spark, LinkedHashMap<String, Object[]> commandList) throws OperationNotSupportedException {
        Object result = spark;
        for (Map.Entry<String, Object[]> command : commandList.entrySet()) {
            String[] cmd = command.getKey().split("#");
            String className = cmd[0];
            String methodName = cmd[1];
            Object[] args = command.getValue();
            Class[] argTypes = (Class[])Stream.of(args).map(Object::getClass).toArray(Class[]::new);
            if (!(className.contains("SparkSession") || className.contains("DataFrameReader") || className.contains("Dataset"))) {
                throw new OperationNotSupportedException(command + " is not yet supported.");
            }
            try {
                Method method = result.getClass().getDeclaredMethod(methodName, argTypes);
                result = method.invoke(result, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (Dataset)result;
    }

    public DataFrameReader read() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        DataFrameReader result = new DataFrameReader(this);
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> baseRelationToDataFrame(BaseRelation baseRelation) {
        boolean userTriggered = this.initializeFunction(new Object[]{baseRelation});
        Dataset<Row> result = Dataset.from(super.baseRelationToDataFrame(baseRelation));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> createDataFrame(JavaRDD<?> rdd, Class<?> beanClass) {
        boolean userTriggered = this.initializeFunction(new Object[]{rdd, beanClass});
        Dataset<Row> result = Dataset.from(super.createDataFrame(rdd, beanClass));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> createDataFrame(JavaRDD<Row> rowRDD, StructType schema) {
        boolean userTriggered = this.initializeFunction(new Object[]{rowRDD, schema});
        Dataset<Row> result = Dataset.from(super.createDataFrame(rowRDD, schema));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> createDataFrame(List<?> data, Class<?> beanClass) {
        boolean userTriggered = this.initializeFunction(new Object[]{data, beanClass});
        Dataset<Row> result = Dataset.from(super.createDataFrame(data, beanClass));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> createDataFrame(List<Row> rows, StructType schema) {
        boolean userTriggered = this.initializeFunction(new Object[]{rows, schema});
        Dataset<Row> result = Dataset.from(super.createDataFrame(rows, schema));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> createDataFrame(RDD<?> rdd, Class<?> beanClass) {
        boolean userTriggered = this.initializeFunction(new Object[]{rdd, beanClass});
        Dataset<Row> result = Dataset.from(super.createDataFrame(rdd, beanClass));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> createDataFrame(RDD<Row> rowRDD, StructType schema) {
        boolean userTriggered = this.initializeFunction(new Object[]{rowRDD, schema});
        Dataset<Row> result = Dataset.from(super.createDataFrame(rowRDD, schema));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <T> Dataset<T> createDataset(List<T> data, Encoder<T> evidence) {
        boolean userTriggered = this.initializeFunction(new Object[]{data, evidence});
        Dataset result = Dataset.from(super.createDataset(data, evidence));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <T> Dataset<T> createDataset(RDD<T> data, Encoder<T> evidence) {
        boolean userTriggered = this.initializeFunction(new Object[]{data, evidence});
        Dataset result = Dataset.from(super.createDataset(data, evidence));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <T> Dataset<T> createDataset(Seq<T> data, Encoder<T> evidence) {
        boolean userTriggered = this.initializeFunction(new Object[]{data, evidence});
        Dataset result = Dataset.from(super.createDataset(data, evidence));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> emptyDataFrame() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset<Row> result = Dataset.from(super.emptyDataFrame());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> sql(String sqlText) {
        boolean userTriggered = this.initializeFunction(new Object[]{sqlText});
        Dataset<Row> result = Dataset.from(super.sql(sqlText));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> table(String tableName) {
        boolean userTriggered = this.initializeFunction(new Object[]{tableName});
        Dataset<Row> result = Dataset.from(super.table(tableName));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    private static SparkSession from(org.apache.spark.sql.SparkSession sparkSession, Map<String, String> initialConf) {
        return new SparkSession((org.apache.nemo.compiler.frontend.spark.core.SparkContext)sparkSession.sparkContext(), initialConf);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends SparkSession.Builder {
        private final Map<String, String> options = new HashMap<String, String>();

        public Builder appName(String name) {
            return (Builder)super.appName(name);
        }

        public synchronized Builder config(SparkConf conf) {
            for (Tuple2 kv : conf.getAll()) {
                this.options.put((String)kv._1, (String)kv._2);
            }
            return (Builder)super.config(conf);
        }

        public synchronized Builder config(Map<String, String> conf) {
            conf.forEach((k, v) -> {
                this.options.put((String)k, (String)v);
                super.config(k, v);
            });
            return this;
        }

        public synchronized Builder config(String key, String value) {
            this.options.put(key, value);
            return (Builder)super.config(key, value);
        }

        public Builder master(String master) {
            return this.config("spark.master", master);
        }

        public synchronized SparkSession getOrCreate() {
            if (!this.options.containsKey("spark.master")) {
                return this.master("local[*]").getOrCreate();
            }
            if (!this.options.containsKey("spark.driver.allowMultipleContexts")) {
                return this.config("spark.driver.allowMultipleContexts", "true").getOrCreate();
            }
            UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)"ubuntu"));
            SparkConf sparkConf = new SparkConf();
            if (!this.options.containsKey("spark.app.name")) {
                try {
                    Configuration configurations = JobLauncher.getBuiltJobConf();
                    Injector injector = Tang.Factory.getTang().newInjector(configurations);
                    this.options.put("spark.app.name", (String)injector.getNamedInstance(JobConf.JobId.class));
                }
                catch (InjectionException e) {
                    throw new RuntimeException(e);
                }
            }
            this.options.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
            org.apache.nemo.compiler.frontend.spark.core.SparkContext sparkContext = new org.apache.nemo.compiler.frontend.spark.core.SparkContext(sparkConf);
            super.sparkContext((SparkContext)sparkContext);
            return SparkSession.from(super.getOrCreate(), this.options);
        }
    }
}

