/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.sql;

import java.util.stream.Stream;
import org.apache.nemo.compiler.frontend.spark.core.rdd.RDD;
import org.apache.nemo.compiler.frontend.spark.core.rdd.SparkJavaRDD;
import org.apache.nemo.compiler.frontend.spark.sql.NemoSparkUserFacingClass;
import org.apache.nemo.compiler.frontend.spark.sql.SparkSession;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.storage.StorageLevel;
import scala.Function1;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class Dataset<T>
extends org.apache.spark.sql.Dataset<T>
implements NemoSparkUserFacingClass {
    private Dataset(SparkSession sparkSession, LogicalPlan logicalPlan, Encoder<T> encoder) {
        super((org.apache.spark.sql.SparkSession)sparkSession, logicalPlan, encoder);
    }

    public static <U> Dataset<U> from(org.apache.spark.sql.Dataset<U> dataset) {
        if (dataset instanceof Dataset) {
            return (Dataset)dataset;
        }
        return new Dataset((SparkSession)dataset.sparkSession(), dataset.logicalPlan(), dataset.exprEnc());
    }

    public SparkJavaRDD<T> javaRDD() {
        return this.toJavaRDD();
    }

    public SparkJavaRDD<T> toJavaRDD() {
        return SparkJavaRDD.of((SparkSession)super.sparkSession(), this);
    }

    public org.apache.spark.rdd.RDD<T> sparkRDD() {
        return super.rdd();
    }

    public RDD<T> rdd() {
        SparkJavaRDD sparkJavaRDD = SparkJavaRDD.of((SparkSession)super.sparkSession(), this);
        return sparkJavaRDD.rdd();
    }

    public Dataset<Row> agg(Column expr, Column ... exprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{expr, exprs});
        Dataset<Row> result = Dataset.from(super.agg(expr, exprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> agg(Column expr, Seq<Column> exprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{expr, exprs});
        Dataset<Row> result = Dataset.from(super.agg(expr, exprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> agg(Map<String, String> exprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{exprs});
        Dataset<Row> result = Dataset.from(super.agg(exprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> agg(java.util.Map<String, String> exprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{exprs});
        Dataset<Row> result = Dataset.from(super.agg(exprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> agg(Tuple2<String, String> aggExpr, Seq<Tuple2<String, String>> aggExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{aggExpr, aggExprs});
        Dataset<Row> result = Dataset.from(super.agg(aggExpr, aggExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> alias(String alias) {
        boolean userTriggered = this.initializeFunction(new Object[]{alias});
        Dataset result = Dataset.from(super.alias(alias));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> alias(Symbol alias) {
        boolean userTriggered = this.initializeFunction(new Object[]{alias});
        Dataset result = Dataset.from(super.alias(alias));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U> Dataset<U> as(Encoder<U> evidence) {
        boolean userTriggered = this.initializeFunction(new Object[]{evidence});
        Dataset<U> result = Dataset.from(super.as(evidence));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> as(String alias) {
        boolean userTriggered = this.initializeFunction(new Object[]{alias});
        Dataset result = Dataset.from(super.as(alias));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> as(Symbol alias) {
        boolean userTriggered = this.initializeFunction(new Object[]{alias});
        Dataset result = Dataset.from(super.as(alias));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> cache() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset result = Dataset.from(super.cache());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> checkpoint() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset result = Dataset.from(super.checkpoint());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> checkpoint(boolean eager) {
        boolean userTriggered = this.initializeFunction(new Object[]{eager});
        Dataset result = Dataset.from(super.checkpoint(eager));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> coalesce(int numPartitions) {
        boolean userTriggered = this.initializeFunction(new Object[]{numPartitions});
        Dataset result = Dataset.from(super.coalesce(numPartitions));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> crossJoin(org.apache.spark.sql.Dataset<?> right) {
        boolean userTriggered = this.initializeFunction(new Object[]{right});
        Dataset<Row> result = Dataset.from(super.crossJoin(right));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> describe(Seq<String> cols) {
        boolean userTriggered = this.initializeFunction(new Object[]{cols});
        Dataset<Row> result = Dataset.from(super.describe(cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> describe(String ... cols) {
        boolean userTriggered = this.initializeFunction(cols);
        Dataset<Row> result = Dataset.from(super.describe(cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> distinct() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset result = Dataset.from(super.distinct());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> drop(Column col) {
        boolean userTriggered = this.initializeFunction(new Object[]{col});
        Dataset<Row> result = Dataset.from(super.drop(col));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> drop(Seq<String> colNames) {
        boolean userTriggered = this.initializeFunction(new Object[]{colNames});
        Dataset<Row> result = Dataset.from(super.drop(colNames));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> drop(String ... colNames) {
        boolean userTriggered = this.initializeFunction(colNames);
        Dataset<Row> result = Dataset.from(super.drop(colNames));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> drop(String colName) {
        boolean userTriggered = this.initializeFunction(new Object[]{colName});
        Dataset<Row> result = Dataset.from(super.drop(colName));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> dropDuplicates() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset result = Dataset.from(super.dropDuplicates());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> dropDuplicates(Seq<String> colNames) {
        boolean userTriggered = this.initializeFunction(new Object[]{colNames});
        Dataset result = Dataset.from(super.dropDuplicates(colNames));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> dropDuplicates(String[] colNames) {
        boolean userTriggered = this.initializeFunction(colNames);
        Dataset result = Dataset.from(super.dropDuplicates(colNames));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> dropDuplicates(String col1, Seq<String> cols) {
        boolean userTriggered = this.initializeFunction(new Object[]{col1, cols});
        Dataset result = Dataset.from(super.dropDuplicates(col1, cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> dropDuplicates(String col1, String ... cols) {
        boolean userTriggered = this.initializeFunction(new Object[]{col1, cols});
        Dataset result = Dataset.from(super.dropDuplicates(col1, cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> except(org.apache.spark.sql.Dataset<T> other) {
        boolean userTriggered = this.initializeFunction(new Object[]{other});
        Dataset result = Dataset.from(super.except(other));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> filter(Column condition) {
        boolean userTriggered = this.initializeFunction(new Object[]{condition});
        Dataset result = Dataset.from(super.filter(condition));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> filter(String conditionExpr) {
        boolean userTriggered = this.initializeFunction(new Object[]{conditionExpr});
        Dataset result = Dataset.from(super.filter(conditionExpr));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> hint(String name, Object ... parameters) {
        boolean userTriggered = this.initializeFunction(new Object[]{name, parameters});
        Dataset result = Dataset.from(super.hint(name, parameters));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> hint(String name, Seq<Object> parameters) {
        boolean userTriggered = this.initializeFunction(new Object[]{name, parameters});
        Dataset result = Dataset.from(super.hint(name, parameters));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> intersect(org.apache.spark.sql.Dataset<T> other) {
        boolean userTriggered = this.initializeFunction(new Object[]{other});
        Dataset result = Dataset.from(super.intersect(other));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> join(org.apache.spark.sql.Dataset<?> right) {
        boolean userTriggered = this.initializeFunction(new Object[]{right});
        Dataset<Row> result = Dataset.from(super.join(right));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> join(org.apache.spark.sql.Dataset<?> right, Column joinExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{right, joinExprs});
        Dataset<Row> result = Dataset.from(super.join(right, joinExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> join(org.apache.spark.sql.Dataset<?> right, Column joinExprs, String joinType) {
        boolean userTriggered = this.initializeFunction(new Object[]{right, joinExprs, joinType});
        Dataset<Row> result = Dataset.from(super.join(right, joinExprs, joinType));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> join(org.apache.spark.sql.Dataset<?> right, Seq<String> usingColumns) {
        boolean userTriggered = this.initializeFunction(new Object[]{right, usingColumns});
        Dataset<Row> result = Dataset.from(super.join(right, usingColumns));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> join(org.apache.spark.sql.Dataset<?> right, Seq<String> usingColumns, String joinType) {
        boolean userTriggered = this.initializeFunction(new Object[]{right, usingColumns, joinType});
        Dataset<Row> result = Dataset.from(super.join(right, usingColumns, joinType));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> join(org.apache.spark.sql.Dataset<?> right, String usingColumn) {
        boolean userTriggered = this.initializeFunction(new Object[]{right, usingColumn});
        Dataset<Row> result = Dataset.from(super.join(right, usingColumn));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> limit(int n) {
        boolean userTriggered = this.initializeFunction(new Object[]{n});
        Dataset result = Dataset.from(super.limit(n));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U> Dataset<U> map(Function1<T, U> func, Encoder<U> evidence) {
        boolean userTriggered = this.initializeFunction(new Object[]{func, evidence});
        Dataset<U> result = Dataset.from(super.map(func, evidence));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U> Dataset<U> map(MapFunction<T, U> func, Encoder<U> encoder) {
        boolean userTriggered = this.initializeFunction(new Object[]{func, encoder});
        Dataset<U> result = Dataset.from(super.map(func, encoder));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U> Dataset<U> mapPartitions(Function1<Iterator<T>, Iterator<U>> func, Encoder<U> evidence) {
        boolean userTriggered = this.initializeFunction(new Object[]{func, evidence});
        Dataset<U> result = Dataset.from(super.mapPartitions(func, evidence));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U> Dataset<U> mapPartitions(MapPartitionsFunction<T, U> f, Encoder<U> encoder) {
        boolean userTriggered = this.initializeFunction(new Object[]{f, encoder});
        Dataset<U> result = Dataset.from(super.mapPartitions(f, encoder));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public static Dataset<Row> ofRows(org.apache.spark.sql.SparkSession sparkSession, LogicalPlan logicalPlan) {
        return Dataset.from(org.apache.spark.sql.Dataset.ofRows((org.apache.spark.sql.SparkSession)sparkSession, (LogicalPlan)logicalPlan));
    }

    public Dataset<T> orderBy(Column ... sortExprs) {
        boolean userTriggered = this.initializeFunction(sortExprs);
        Dataset result = Dataset.from(super.orderBy(sortExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> orderBy(Seq<Column> sortExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortExprs});
        Dataset result = Dataset.from(super.orderBy(sortExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> orderBy(String sortCol, Seq<String> sortCols) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortCol, sortCols});
        Dataset result = Dataset.from(super.orderBy(sortCol, sortCols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> orderBy(String sortCol, String ... sortCols) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortCol, sortCols});
        Dataset result = Dataset.from(super.orderBy(sortCol, sortCols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> persist() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset result = Dataset.from(super.persist());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> persist(StorageLevel newLevel) {
        boolean userTriggered = this.initializeFunction(new Object[]{newLevel});
        Dataset result = Dataset.from(super.persist(newLevel));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T>[] randomSplit(double[] weights) {
        boolean userTriggered = this.initializeFunction(new Object[]{weights});
        Dataset[] result = (Dataset[])Stream.of(super.randomSplit(weights)).map(ds -> Dataset.from(ds)).toArray(Dataset[]::new);
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T>[] randomSplit(double[] weights, long seed) {
        boolean userTriggered = this.initializeFunction(new Object[]{weights, seed});
        Dataset[] result = (Dataset[])Stream.of(super.randomSplit(weights, seed)).map(ds -> Dataset.from(ds)).toArray(Dataset[]::new);
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> repartition(Column ... partitionExprs) {
        boolean userTriggered = this.initializeFunction(partitionExprs);
        Dataset result = Dataset.from(super.repartition(partitionExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> repartition(int numPartitions) {
        boolean userTriggered = this.initializeFunction(new Object[]{numPartitions});
        Dataset result = Dataset.from(super.repartition(numPartitions));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> repartition(int numPartitions, Column ... partitionExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{numPartitions, partitionExprs});
        Dataset result = Dataset.from(super.repartition(numPartitions, partitionExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> repartition(int numPartitions, Seq<Column> partitionExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{numPartitions, partitionExprs});
        Dataset result = Dataset.from(super.repartition(numPartitions, partitionExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> repartition(Seq<Column> partitionExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{partitionExprs});
        Dataset result = Dataset.from(super.repartition(partitionExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sample(boolean withReplacement, double fraction) {
        boolean userTriggered = this.initializeFunction(new Object[]{withReplacement, fraction});
        Dataset result = Dataset.from(super.sample(withReplacement, fraction));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sample(boolean withReplacement, double fraction, long seed) {
        boolean userTriggered = this.initializeFunction(new Object[]{withReplacement, fraction, seed});
        Dataset result = Dataset.from(super.sample(withReplacement, fraction, seed));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> select(Column ... cols) {
        boolean userTriggered = this.initializeFunction(cols);
        Dataset<Row> result = Dataset.from(super.select(cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> select(Seq<Column> cols) {
        boolean userTriggered = this.initializeFunction(new Object[]{cols});
        Dataset<Row> result = Dataset.from(super.select(cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> select(String col, Seq<String> cols) {
        boolean userTriggered = this.initializeFunction(new Object[]{col, cols});
        Dataset<Row> result = Dataset.from(super.select(col, cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> select(String col, String ... cols) {
        boolean userTriggered = this.initializeFunction(new Object[]{col, cols});
        Dataset<Row> result = Dataset.from(super.select(col, cols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U1> Dataset<U1> select(TypedColumn<T, U1> c1) {
        boolean userTriggered = this.initializeFunction(new Object[]{c1});
        Dataset result = Dataset.from(super.select(c1));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> selectExpr(Seq<String> exprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{exprs});
        Dataset<Row> result = Dataset.from(super.selectExpr(exprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> selectExpr(String ... exprs) {
        boolean userTriggered = this.initializeFunction(exprs);
        Dataset<Row> result = Dataset.from(super.selectExpr(exprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sort(Column ... sortExprs) {
        boolean userTriggered = this.initializeFunction(sortExprs);
        Dataset result = Dataset.from(super.sort(sortExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sort(Seq<Column> sortExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortExprs});
        Dataset result = Dataset.from(super.sort(sortExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sort(String sortCol, Seq<String> sortCols) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortCol, sortCols});
        Dataset result = Dataset.from(super.sort(sortCol, sortCols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sort(String sortCol, String ... sortCols) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortCol, sortCols});
        Dataset result = Dataset.from(super.sort(sortCol, sortCols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sortWithinPartitions(Column ... sortExprs) {
        boolean userTriggered = this.initializeFunction(sortExprs);
        Dataset result = Dataset.from(super.sortWithinPartitions(sortExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sortWithinPartitions(Seq<Column> sortExprs) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortExprs});
        Dataset result = Dataset.from(super.sortWithinPartitions(sortExprs));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sortWithinPartitions(String sortCol, Seq<String> sortCols) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortCol, sortCols});
        Dataset result = Dataset.from(super.sortWithinPartitions(sortCol, sortCols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> sortWithinPartitions(String sortCol, String ... sortCols) {
        boolean userTriggered = this.initializeFunction(new Object[]{sortCol, sortCols});
        Dataset result = Dataset.from(super.sortWithinPartitions(sortCol, sortCols));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    @Override
    public SparkSession sparkSession() {
        return (SparkSession)super.sparkSession();
    }

    public Dataset<Row> toDF() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset<Row> result = Dataset.from(super.toDF());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> toDF(Seq<String> colNames) {
        boolean userTriggered = this.initializeFunction(new Object[]{colNames});
        Dataset<Row> result = Dataset.from(super.toDF(colNames));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> toDF(String ... colNames) {
        boolean userTriggered = this.initializeFunction(colNames);
        Dataset<Row> result = Dataset.from(super.toDF(colNames));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<String> toJSON() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset<String> result = Dataset.from(super.toJSON());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public <U> Dataset<U> transform(Function1<org.apache.spark.sql.Dataset<T>, org.apache.spark.sql.Dataset<U>> t) {
        boolean userTriggered = this.initializeFunction(new Object[]{t});
        Dataset<U> result = Dataset.from(super.transform(t));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> union(org.apache.spark.sql.Dataset<T> other) {
        boolean userTriggered = this.initializeFunction(new Object[]{other});
        Dataset result = Dataset.from(super.union(other));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> unpersist() {
        boolean userTriggered = this.initializeFunction(new Object[0]);
        Dataset result = Dataset.from(super.unpersist());
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> unpersist(boolean blocking) {
        boolean userTriggered = this.initializeFunction(new Object[]{blocking});
        Dataset result = Dataset.from(super.unpersist(blocking));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> where(Column condition) {
        boolean userTriggered = this.initializeFunction(new Object[]{condition});
        Dataset result = Dataset.from(super.where(condition));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<T> where(String conditionExpr) {
        boolean userTriggered = this.initializeFunction(new Object[]{conditionExpr});
        Dataset result = Dataset.from(super.where(conditionExpr));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> withColumn(String colName, Column col) {
        boolean userTriggered = this.initializeFunction(new Object[]{colName, col});
        Dataset<Row> result = Dataset.from(super.withColumn(colName, col));
        this.setIsUserTriggered(userTriggered);
        return result;
    }

    public Dataset<Row> withColumnRenamed(String existingName, String newName) {
        boolean userTriggered = this.initializeFunction(new Object[]{existingName, newName});
        Dataset<Row> result = Dataset.from(super.withColumnRenamed(existingName, newName));
        this.setIsUserTriggered(userTriggered);
        return result;
    }
}

