/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.nemo.common.ir.BoundedIteratorReadable;
import org.apache.nemo.common.ir.Readable;
import org.apache.nemo.common.ir.vertex.SourceVertex;
import org.apache.nemo.compiler.frontend.spark.source.SparkSourceUtil;
import org.apache.spark.Partition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.SizeEstimator;
import scala.collection.Iterator;
import scala.collection.JavaConverters;

public final class SparkTextFileBoundedSourceVertex
extends SourceVertex<String> {
    private List<Readable<String>> readables = new ArrayList<Readable<String>>();
    private long estimatedSizeBytes;

    public SparkTextFileBoundedSourceVertex(SparkContext sparkContext, String inputPath, int numPartitions) {
        Partition[] partitions = sparkContext.textFile(inputPath, numPartitions).getPartitions();
        for (int i = 0; i < partitions.length; ++i) {
            this.readables.add((Readable<String>)new SparkTextFileBoundedSourceReadable(partitions[i], sparkContext.getConf(), i, inputPath, numPartitions));
        }
        this.estimatedSizeBytes = SizeEstimator.estimate((Object)sparkContext.textFile(inputPath, numPartitions));
    }

    private SparkTextFileBoundedSourceVertex(SparkTextFileBoundedSourceVertex that) {
        super((SourceVertex)that);
        that.readables.forEach(this.readables::add);
    }

    public SparkTextFileBoundedSourceVertex getClone() {
        return new SparkTextFileBoundedSourceVertex(this);
    }

    public boolean isBounded() {
        return true;
    }

    public List<Readable<String>> getReadables(int desiredNumOfSplits) {
        return this.readables;
    }

    public long getEstimatedSizeBytes() {
        return this.estimatedSizeBytes;
    }

    public void clearInternalStates() {
        this.readables = null;
    }

    private final class SparkTextFileBoundedSourceReadable
    extends BoundedIteratorReadable<String> {
        private final SparkConf sparkConf;
        private final int partitionIndex;
        private final List<String> locations;
        private final String inputPath;
        private final int numPartitions;

        private SparkTextFileBoundedSourceReadable(Partition partition, SparkConf sparkConf, int partitionIndex, String inputPath, int numPartitions) {
            this.sparkConf = sparkConf;
            this.partitionIndex = partitionIndex;
            this.inputPath = inputPath;
            this.numPartitions = numPartitions;
            this.locations = SparkSourceUtil.getPartitionLocation(partition);
        }

        public long readWatermark() {
            throw new UnsupportedOperationException("No watermark");
        }

        public List<String> getLocations() {
            if (this.locations.isEmpty()) {
                throw new UnsupportedOperationException();
            }
            return this.locations;
        }

        public void close() throws IOException {
        }

        protected java.util.Iterator<String> initializeIterator() {
            SparkContext sparkContext = SparkContext.getOrCreate((SparkConf)this.sparkConf);
            RDD rdd = sparkContext.textFile(this.inputPath, this.numPartitions);
            Iterable iterable = () -> (java.util.Iterator)JavaConverters.asJavaIteratorConverter((Iterator)rdd.iterator(rdd.getPartitions()[this.partitionIndex], (TaskContext)TaskContext$.MODULE$.empty())).asJava();
            return iterable.iterator();
        }
    }
}

