/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.source;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.spark.Partition;
import org.apache.spark.SerializableWritable;
import org.apache.spark.rdd.HadoopPartition;

final class SparkSourceUtil {
    private SparkSourceUtil() {
    }

    static List<String> getPartitionLocation(Partition partition) {
        try {
            if (partition instanceof HadoopPartition) {
                Field inputSplitField = partition.getClass().getDeclaredField("inputSplit");
                inputSplitField.setAccessible(true);
                InputSplit inputSplit = (InputSplit)((SerializableWritable)inputSplitField.get(partition)).value();
                String[] splitLocations = inputSplit.getLocations();
                ArrayList<String> parsedLocations = new ArrayList<String>();
                for (String loc : splitLocations) {
                    String canonicalHostName = InetAddress.getByName(loc).getCanonicalHostName();
                    parsedLocations.add(canonicalHostName);
                }
                if (parsedLocations.size() == 1 && ((String)parsedLocations.get(0)).equals("localhost")) {
                    return Collections.emptyList();
                }
                return parsedLocations;
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

