/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.core.rdd;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.nemo.common.dag.DAG;
import org.apache.nemo.common.dag.DAGBuilder;
import org.apache.nemo.common.dag.Vertex;
import org.apache.nemo.common.ir.edge.IREdge;
import org.apache.nemo.common.ir.executionproperty.VertexExecutionProperty;
import org.apache.nemo.common.ir.vertex.IRVertex;
import org.apache.nemo.common.ir.vertex.InMemorySourceVertex;
import org.apache.nemo.common.ir.vertex.executionproperty.ParallelismProperty;
import org.apache.nemo.compiler.frontend.spark.core.SparkFrontendUtils;
import org.apache.nemo.compiler.frontend.spark.core.rdd.RDD;
import org.apache.nemo.compiler.frontend.spark.core.rdd.SparkJavaPairRDD;
import org.apache.nemo.compiler.frontend.spark.source.SparkDatasetBoundedSourceVertex;
import org.apache.nemo.compiler.frontend.spark.source.SparkTextFileBoundedSourceVertex;
import org.apache.nemo.compiler.frontend.spark.sql.Dataset;
import org.apache.nemo.compiler.frontend.spark.sql.SparkSession;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.storage.StorageLevel;
import scala.Option;
import scala.reflect.ClassTag$;

public final class SparkJavaRDD<T>
extends JavaRDD<T> {
    private final RDD<T> rdd;
    private static final String NOT_YET_SUPPORTED = "Operation not yet supported.";
    private static final AtomicInteger RESULT_ID = new AtomicInteger(0);

    public static <T> SparkJavaRDD<T> of(SparkContext sparkContext, Iterable<T> initialData, Integer parallelism) {
        DAGBuilder builder = new DAGBuilder();
        InMemorySourceVertex initializedSourceVertex = new InMemorySourceVertex(initialData);
        initializedSourceVertex.setProperty((VertexExecutionProperty)ParallelismProperty.of((Integer)parallelism));
        builder.addVertex((Vertex)initializedSourceVertex);
        RDD nemoRdd = new RDD(sparkContext, (DAG<IRVertex, IREdge>)builder.buildWithoutSourceSinkCheck(), (IRVertex)initializedSourceVertex, Option.empty(), ClassTag$.MODULE$.apply(Object.class));
        return new SparkJavaRDD(nemoRdd);
    }

    public static SparkJavaRDD<String> of(SparkContext sparkContext, int minPartitions, String inputPath) {
        DAGBuilder builder = new DAGBuilder();
        org.apache.spark.rdd.RDD textRdd = sparkContext.textFile(inputPath, minPartitions);
        int numPartitions = textRdd.getNumPartitions();
        SparkTextFileBoundedSourceVertex textSourceVertex = new SparkTextFileBoundedSourceVertex(sparkContext, inputPath, numPartitions);
        textSourceVertex.setProperty((VertexExecutionProperty)ParallelismProperty.of((Integer)numPartitions));
        builder.addVertex((Vertex)textSourceVertex);
        return new SparkJavaRDD<String>(textRdd, sparkContext, (DAG<IRVertex, IREdge>)builder.buildWithoutSourceSinkCheck(), (IRVertex)textSourceVertex);
    }

    public static <T> SparkJavaRDD<T> of(SparkSession sparkSession, Dataset<T> dataset) {
        DAGBuilder builder = new DAGBuilder();
        SparkDatasetBoundedSourceVertex<T> sparkBoundedSourceVertex = new SparkDatasetBoundedSourceVertex<T>(sparkSession, dataset);
        org.apache.spark.rdd.RDD<T> sparkRDD = dataset.sparkRDD();
        sparkBoundedSourceVertex.setProperty((VertexExecutionProperty)ParallelismProperty.of((Integer)sparkRDD.getNumPartitions()));
        builder.addVertex(sparkBoundedSourceVertex);
        return new SparkJavaRDD<T>(sparkRDD, sparkSession.sparkContext(), (DAG<IRVertex, IREdge>)builder.buildWithoutSourceSinkCheck(), (IRVertex)sparkBoundedSourceVertex);
    }

    public static <T> SparkJavaRDD<T> fromRDD(RDD<T> rddFrom) {
        return new SparkJavaRDD<T>(rddFrom);
    }

    public SparkJavaRDD<T> wrapRDD(org.apache.spark.rdd.RDD<T> rddFrom) {
        if (!(rddFrom instanceof RDD)) {
            throw new UnsupportedOperationException("Cannot wrap Spark RDD as Nemo RDD!");
        }
        return SparkJavaRDD.fromRDD((RDD)rddFrom);
    }

    public RDD<T> rdd() {
        return this.rdd;
    }

    SparkJavaRDD(RDD<T> rdd) {
        super(rdd, ClassTag$.MODULE$.apply(Object.class));
        this.rdd = rdd;
    }

    SparkJavaRDD(org.apache.spark.rdd.RDD<T> sparkRDD, SparkContext sparkContext, DAG<IRVertex, IREdge> dag, IRVertex lastVertex) {
        super(sparkRDD, ClassTag$.MODULE$.apply(Object.class));
        this.rdd = new RDD(sparkContext, dag, lastVertex, Option.apply(sparkRDD), ClassTag$.MODULE$.apply(Object.class));
    }

    public <O> SparkJavaRDD<O> map(Function<T, O> func) {
        return this.rdd.map(func, ClassTag$.MODULE$.apply(Object.class)).toJavaRDD();
    }

    public <O> SparkJavaRDD<O> flatMap(FlatMapFunction<T, O> func) {
        return this.rdd.flatMap(func, ClassTag$.MODULE$.apply(Object.class)).toJavaRDD();
    }

    public <K2, V2> SparkJavaPairRDD<K2, V2> mapToPair(PairFunction<T, K2, V2> f) {
        RDD pairRdd = this.rdd.map(SparkFrontendUtils.pairFunctionToPlainFunction(f), ClassTag$.MODULE$.apply(Object.class));
        return SparkJavaPairRDD.fromRDD(pairRdd);
    }

    public static Integer getResultId() {
        return RESULT_ID.getAndIncrement();
    }

    public T reduce(Function2<T, T, T> func) {
        return this.rdd.reduce(func);
    }

    public List<T> collect() {
        return this.rdd.collectAsList();
    }

    public void saveAsTextFile(String path) {
        this.rdd.saveAsTextFile(path);
    }

    public SparkJavaRDD<T> persist(StorageLevel newLevel) {
        return this.rdd.persist(newLevel).toJavaRDD();
    }

    public SparkJavaRDD<T> cache() {
        return this.rdd.cache().toJavaRDD();
    }

    public SparkJavaRDD<T> coalesce(int numPartitions) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> coalesce(int numPartitions, boolean shuffle) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> distinct() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> distinct(int numPartitions) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> filter(Function<T, Boolean> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<List<T>> glom() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> SparkJavaRDD<U> mapPartitions(FlatMapFunction<Iterator<T>, U> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> SparkJavaRDD<U> mapPartitions(FlatMapFunction<Iterator<T>, U> f, boolean preservesPartitioning) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <R> SparkJavaRDD<R> mapPartitionsWithIndex(Function2<Integer, Iterator<T>, Iterator<R>> f, boolean preservesPartitioning) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T>[] randomSplit(double[] weights) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T>[] randomSplit(double[] weights, long seed) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> repartition(int numPartitions) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> sample(boolean withReplacement, double fraction) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> sample(boolean withReplacement, double fraction, long seed) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> setName(String name) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <S> SparkJavaRDD<T> sortBy(Function<T, S> f, boolean ascending, int numPartitions) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> unpersist() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaRDD<T> unpersist(boolean blocking) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <K2, V2> SparkJavaPairRDD<K2, V2> flatMapToPair(PairFlatMapFunction<T, K2, V2> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> SparkJavaPairRDD<U, Iterable<T>> groupBy(Function<T, U> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> SparkJavaPairRDD<U, Iterable<T>> groupBy(Function<T, U> f, int numPartitions) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> SparkJavaPairRDD<U, T> keyBy(Function<T, U> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <K2, V2> SparkJavaPairRDD<K2, V2> mapPartitionsToPair(PairFlatMapFunction<Iterator<T>, K2, V2> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <K2, V2> SparkJavaPairRDD<K2, V2> mapPartitionsToPair(PairFlatMapFunction<Iterator<T>, K2, V2> f, boolean preservesPartitioning) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaPairRDD<T, Long> zipWithIndex() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public SparkJavaPairRDD<T, Long> zipWithUniqueId() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> U aggregate(U zeroValue, Function2<U, T, U> seqOp, Function2<U, U, U> combOp) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void checkpoint() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public JavaFutureAction<List<T>> collectAsync() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T>[] collectPartitions(int[] partitionIds) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public long count() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public PartialResult<BoundedDouble> countApprox(long timeout) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public long countApproxDistinct(double relativeSD) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public JavaFutureAction<Long> countAsync() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public Map<T, Long> countByValue() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public PartialResult<Map<T, BoundedDouble>> countByValueApprox(long timeout) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public PartialResult<Map<T, BoundedDouble>> countByValueApprox(long timeout, double confidence) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public T first() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public T fold(T zeroValue, Function2<T, T, T> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void foreach(VoidFunction<T> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public JavaFutureAction<Void> foreachAsync(VoidFunction<T> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void foreachPartition(VoidFunction<Iterator<T>> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public JavaFutureAction<Void> foreachPartitionAsync(VoidFunction<Iterator<T>> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public Optional<String> getCheckpointFile() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public int getNumPartitions() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public StorageLevel getStorageLevel() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public int id() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public boolean isCheckpointed() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public Iterator<T> iterator(Partition split, TaskContext taskContext) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public T max(Comparator<T> comp) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public T min(Comparator<T> comp) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public String name() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public Optional<Partitioner> partitioner() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<Partition> partitions() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void saveAsObjectFile(String path) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public void saveAsTextFile(String path, Class<? extends CompressionCodec> codec) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> take(int num) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public JavaFutureAction<List<T>> takeAsync(int num) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> takeOrdered(int num) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> takeOrdered(int num, Comparator<T> comp) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> takeSample(boolean withReplacement, int num) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> takeSample(boolean withReplacement, int num, long seed) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public String toDebugString() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public Iterator<T> toLocalIterator() {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> top(int num) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public List<T> top(int num, Comparator<T> comp) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> U treeAggregate(U zeroValue, Function2<U, T, U> seqOp, Function2<U, U, U> combOp) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public <U> U treeAggregate(U zeroValue, Function2<U, T, U> seqOp, Function2<U, U, U> combOp, int depth) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public T treeReduce(Function2<T, T, T> f) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }

    public T treeReduce(Function2<T, T, T> f, int depth) {
        throw new UnsupportedOperationException(NOT_YET_SUPPORTED);
    }
}

