/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.core;

import java.util.List;
import org.apache.nemo.compiler.frontend.spark.SparkBroadcastVariables;
import org.apache.nemo.compiler.frontend.spark.core.SparkBroadcast;
import org.apache.nemo.compiler.frontend.spark.core.rdd.RDD;
import org.apache.nemo.compiler.frontend.spark.core.rdd.SparkJavaRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.broadcast.Broadcast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.ClassTag;

public final class SparkContext
extends org.apache.spark.SparkContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)SparkContext.class.getName());
    private final org.apache.spark.SparkContext sparkContext;

    public SparkContext() {
        this.sparkContext = org.apache.spark.SparkContext.getOrCreate();
    }

    public SparkContext(SparkConf sparkConf) {
        super(sparkConf);
        this.sparkContext = org.apache.spark.SparkContext.getOrCreate((SparkConf)sparkConf);
    }

    public <T> RDD<T> parallelize(Seq<T> seq, int numSlices, ClassTag<T> evidence) {
        List javaList = JavaConversions.seqAsJavaList(seq);
        return SparkJavaRDD.of(this.sparkContext, javaList, numSlices).rdd();
    }

    public <T> Broadcast<T> broadcast(T data, ClassTag<T> evidence) {
        long id = SparkBroadcastVariables.register(data);
        return new SparkBroadcast(id, data.getClass());
    }
}

