/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.coder;

import java.io.OutputStream;
import org.apache.nemo.common.coder.EncoderFactory;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import scala.reflect.ClassTag$;

public final class SparkEncoderFactory<T>
implements EncoderFactory<T> {
    private final transient Serializer serializer;

    public SparkEncoderFactory(Serializer serializer) {
        this.serializer = serializer;
    }

    public EncoderFactory.Encoder<T> create(OutputStream outputStream) {
        return new SparkEncoder(outputStream, this.serializer.newInstance());
    }

    public String toString() {
        return "SparkEncoderFactory{serializer=" + this.serializer + '}';
    }

    private final class SparkEncoder<T2>
    implements EncoderFactory.Encoder<T2> {
        private final transient SerializationStream out;

        private SparkEncoder(OutputStream outputStream, SerializerInstance sparkSerializerInstance) {
            this.out = sparkSerializerInstance.serializeStream(outputStream);
        }

        public void encode(T2 element) {
            this.out.writeObject(element, ClassTag$.MODULE$.Any());
        }
    }
}

