/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark.coder;

import java.io.InputStream;
import org.apache.nemo.common.coder.DecoderFactory;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import scala.reflect.ClassTag$;

public final class SparkDecoderFactory<T>
implements DecoderFactory<T> {
    private final transient Serializer serializer;

    public SparkDecoderFactory(Serializer serializer) {
        this.serializer = serializer;
    }

    public DecoderFactory.Decoder<T> create(InputStream inputStream) {
        return new SparkDecoder(inputStream, this.serializer.newInstance());
    }

    public String toString() {
        return "SparkDecoderFactory{serializer=" + this.serializer + '}';
    }

    private final class SparkDecoder<T2>
    implements DecoderFactory.Decoder<T2> {
        private final transient DeserializationStream in;

        private SparkDecoder(InputStream inputStream, SerializerInstance sparkSerializerInstance) {
            this.in = sparkSerializerInstance.deserializeStream(inputStream);
        }

        public T2 decode() {
            return (T2)this.in.readObject(ClassTag$.MODULE$.Any());
        }
    }
}

