/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nemo.compiler.frontend.spark;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkBroadcastVariables {
    private static final Logger LOG = LoggerFactory.getLogger((String)SparkBroadcastVariables.class.getName());
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private static final Map<Serializable, Object> ID_TO_VARIABLE = new HashMap<Serializable, Object>();

    private SparkBroadcastVariables() {
    }

    public static long register(Object variable) {
        long id = ID_GENERATOR.getAndIncrement();
        ID_TO_VARIABLE.put(Long.valueOf(id), variable);
        LOG.info("Registered Spark broadcast variable with id {}", (Object)id);
        return id;
    }

    public static Map<Serializable, Object> getAll() {
        return ID_TO_VARIABLE;
    }
}

