/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package javax.faces.component.html;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;


// Generated from class javax.faces.component.html._HtmlMessage.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlMessage extends javax.faces.component.UIMessage
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Message";
    static public final String COMPONENT_TYPE =
        "javax.faces.HtmlMessage";


    public HtmlMessage()
    {
        setRendererType("javax.faces.Message");
    }

    @Override    
    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }



    
    // Property: style

    public String getStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.style);
    }
    
    public void setStyle(String style)
    {
        getStateHelper().put(PropertyKeys.style, style ); 
    }    
    // Property: styleClass

    public String getStyleClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.styleClass);
    }
    
    public void setStyleClass(String styleClass)
    {
        getStateHelper().put(PropertyKeys.styleClass, styleClass ); 
    }    
    // Property: errorClass

    public String getErrorClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.errorClass);
    }
    
    public void setErrorClass(String errorClass)
    {
        getStateHelper().put(PropertyKeys.errorClass, errorClass ); 
    }    
    // Property: errorStyle

    public String getErrorStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.errorStyle);
    }
    
    public void setErrorStyle(String errorStyle)
    {
        getStateHelper().put(PropertyKeys.errorStyle, errorStyle ); 
    }    
    // Property: fatalClass

    public String getFatalClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.fatalClass);
    }
    
    public void setFatalClass(String fatalClass)
    {
        getStateHelper().put(PropertyKeys.fatalClass, fatalClass ); 
    }    
    // Property: fatalStyle

    public String getFatalStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.fatalStyle);
    }
    
    public void setFatalStyle(String fatalStyle)
    {
        getStateHelper().put(PropertyKeys.fatalStyle, fatalStyle ); 
    }    
    // Property: infoClass

    public String getInfoClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.infoClass);
    }
    
    public void setInfoClass(String infoClass)
    {
        getStateHelper().put(PropertyKeys.infoClass, infoClass ); 
    }    
    // Property: infoStyle

    public String getInfoStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.infoStyle);
    }
    
    public void setInfoStyle(String infoStyle)
    {
        getStateHelper().put(PropertyKeys.infoStyle, infoStyle ); 
    }    
    // Property: tooltip

    public boolean isTooltip()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.tooltip, false);
    }
    
    public void setTooltip(boolean tooltip)
    {
        getStateHelper().put(PropertyKeys.tooltip, tooltip ); 
    }    
    // Property: warnClass

    public String getWarnClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.warnClass);
    }
    
    public void setWarnClass(String warnClass)
    {
        getStateHelper().put(PropertyKeys.warnClass, warnClass ); 
    }    
    // Property: warnStyle

    public String getWarnStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.warnStyle);
    }
    
    public void setWarnStyle(String warnStyle)
    {
        getStateHelper().put(PropertyKeys.warnStyle, warnStyle ); 
    }    
    // Property: dir

    public String getDir()
    {
        return (String) getStateHelper().eval(PropertyKeys.dir);
    }
    
    public void setDir(String dir)
    {
        getStateHelper().put(PropertyKeys.dir, dir ); 
    }    
    // Property: lang

    public String getLang()
    {
        return (String) getStateHelper().eval(PropertyKeys.lang);
    }
    
    public void setLang(String lang)
    {
        getStateHelper().put(PropertyKeys.lang, lang ); 
    }    
    // Property: title

    public String getTitle()
    {
        return (String) getStateHelper().eval(PropertyKeys.title);
    }
    
    public void setTitle(String title)
    {
        getStateHelper().put(PropertyKeys.title, title ); 
    }    

    protected enum PropertyKeys
    {
         style
        , styleClass
        , errorClass
        , errorStyle
        , fatalClass
        , fatalStyle
        , infoClass
        , infoStyle
        , tooltip
        , warnClass
        , warnStyle
        , dir
        , lang
        , title
    }

 }
