/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.resourcehandler.webapp.config.impl;

import java.io.IOException;
import java.net.URL;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.commons.resourcehandler.webapp.config.WebConfigProvider;
import org.apache.myfaces.commons.resourcehandler.webapp.config.WebConfigProviderFactory;
import org.apache.myfaces.commons.resourcehandler.webapp.config.WebRegistration;
import org.apache.myfaces.commons.resourcehandler.webapp.config.impl.WebXmlConfigParser;
import org.apache.myfaces.commons.resourcehandler.webapp.config.impl._ExternalSpecifications;
import org.apache.myfaces.commons.resourcehandler.webapp.config.impl._Servlet30Utils;
import org.apache.myfaces.commons.util.WebConfigParamUtils;

public class WebConfigProviderImpl
extends WebConfigProvider {
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private static final String WEB_REGISTRATION_KEY = WebRegistration.class.getName();
    private static final String INIT_PARAM_CONFIG_REFRESH_PERIOD = "org.apache.myfaces.CONFIG_REFRESH_PERIOD";
    private static final long INIT_PARAM_CONFIG_REFRESH_PERIOD_DEFAULT = 2L;
    private long refreshPeriod = -1L;
    private long parsingTime = -1L;
    private Boolean servlet30Mode;

    public WebRegistration getWebRegistration(FacesContext context) {
        WebRegistration webConfig = (WebRegistration)context.getExternalContext().getApplicationMap().get(WEB_REGISTRATION_KEY);
        if (webConfig == null) {
            this.init(context);
            webConfig = (WebRegistration)context.getExternalContext().getApplicationMap().get(WEB_REGISTRATION_KEY);
        }
        return webConfig;
    }

    public void init(FacesContext context) {
        if (this.servlet30Mode == null) {
            this.servlet30Mode = context.getExternalContext().getContext() instanceof ServletContext && _ExternalSpecifications.isServlet30Available();
        }
        if (this.servlet30Mode.booleanValue()) {
            ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
            context.getExternalContext().getApplicationMap().put(WEB_REGISTRATION_KEY, _Servlet30Utils.getWebRegistrationFromServlet30Api(servletContext));
        } else {
            context.getExternalContext().getApplicationMap().put(WEB_REGISTRATION_KEY, WebXmlConfigParser.getWebRegistrationFromParsedWebXml(context));
        }
        if (!context.isProjectStage(ProjectStage.Production)) {
            long configRefreshPeriod = WebConfigParamUtils.getLongInitParameter((ExternalContext)context.getExternalContext(), (String)INIT_PARAM_CONFIG_REFRESH_PERIOD, (long)2L);
            this.parsingTime = System.currentTimeMillis();
            this.refreshPeriod = configRefreshPeriod * 1000L;
        }
    }

    public void update(FacesContext context) {
        if (this.servlet30Mode == null) {
            this.servlet30Mode = context.getExternalContext().getContext() instanceof ServletContext && _ExternalSpecifications.isServlet30Available();
        }
        if (!this.servlet30Mode.booleanValue() && !context.isProjectStage(ProjectStage.Production) && this.isOld(context.getExternalContext())) {
            this.init(context);
        }
    }

    private boolean isOld(ExternalContext context) {
        if (this.refreshPeriod > 0L) {
            long ttl = this.parsingTime + this.refreshPeriod;
            if (System.currentTimeMillis() > ttl) {
                long lastModified = WebConfigProviderImpl.getWebXmlLastModified(context);
                return lastModified == 0L || lastModified > ttl;
            }
        }
        return false;
    }

    private static long getWebXmlLastModified(ExternalContext context) {
        block3: {
            try {
                URL url = context.getResource(WEB_XML_PATH);
                if (url != null) {
                    return url.openConnection().getLastModified();
                }
            }
            catch (IOException e) {
                Log log = LogFactory.getLog(WebConfigProviderFactory.class);
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not find web.xml in path /WEB-INF/web.xml");
            }
        }
        return 0L;
    }
}

