/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.resourcehandler.resource;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.commons.resourcehandler.application.FacesServletMapping;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceHandlerSupport;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceLoader;
import org.apache.myfaces.commons.util.WebConfigParamUtils;

public class BaseResourceHandlerSupport
extends ResourceHandlerSupport {
    public static final String RESOURCE_MAX_TIME_EXPIRES = "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES";
    private static final String CACHED_SERVLET_MAPPING = BaseResourceHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private Long _startupTime = System.currentTimeMillis();
    private Long _maxTimeExpires;

    public ResourceLoader[] getResourceLoaders() {
        return null;
    }

    public String calculateResourceBasePath(FacesContext facesContext) {
        FacesServletMapping mapping = this.getFacesServletMapping(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (mapping != null) {
            String resourceBasePath = null;
            if (mapping.isExtensionMapping()) {
                resourceBasePath = externalContext.getRequestServletPath();
                int stripPoint = resourceBasePath.lastIndexOf(46);
                if (stripPoint > 0) {
                    resourceBasePath = resourceBasePath.substring(0, stripPoint);
                }
            } else {
                resourceBasePath = externalContext.getRequestPathInfo();
            }
            return resourceBasePath;
        }
        return externalContext.getRequestPathInfo();
    }

    public boolean isExtensionMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        return mapping != null && mapping.isExtensionMapping();
    }

    public String getMapping() {
        FacesServletMapping mapping = this.getFacesServletMapping(FacesContext.getCurrentInstance());
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                return mapping.getExtension();
            }
            return mapping.getPrefix();
        }
        return "";
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = BaseResourceHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    public long getStartupTime() {
        return this._startupTime;
    }

    public long getMaxTimeExpires() {
        if (this._maxTimeExpires == null) {
            this._maxTimeExpires = WebConfigParamUtils.getLongInitParameter((ExternalContext)FacesContext.getCurrentInstance().getExternalContext(), (String)RESOURCE_MAX_TIME_EXPIRES, (long)604800000L);
        }
        return this._maxTimeExpires;
    }
}

