/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.resourcehandler;

public class ResourceUtils {
    public static boolean isGZIPEncodingAccepted(String acceptEncodingHeader) {
        if (acceptEncodingHeader == null) {
            return false;
        }
        int gzipIndex = acceptEncodingHeader.indexOf("gzip");
        if (gzipIndex != -1) {
            return !ResourceUtils.isEncodingQValueZero(acceptEncodingHeader, gzipIndex);
        }
        int starIndex = acceptEncodingHeader.indexOf(42);
        if (starIndex != -1) {
            return !ResourceUtils.isEncodingQValueZero(acceptEncodingHeader, starIndex);
        }
        return false;
    }

    private static boolean isEncodingQValueZero(String acceptEncodingHeader, int startIndex) {
        int qZeroIndex;
        String encodingSubstring = acceptEncodingHeader.substring(startIndex);
        int commaIndex = encodingSubstring.indexOf(44);
        if (commaIndex != -1) {
            encodingSubstring = encodingSubstring.substring(0, commaIndex);
        }
        if ((qZeroIndex = encodingSubstring.indexOf("q=0")) != -1) {
            String qZeroSubstring = encodingSubstring.substring(qZeroIndex).trim();
            return qZeroSubstring.matches("q=0(\\.(0){0,3})?");
        }
        return false;
    }
}

