/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.resourcehandler;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import org.apache.myfaces.commons.resourcehandler.ExtendedDefaultResourceHandlerSupport;
import org.apache.myfaces.commons.resourcehandler.ExtendedResourceMeta;
import org.apache.myfaces.commons.resourcehandler.config.element.Library;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceImpl;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceLoader;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceValidationUtils;

public class ExtendedResourceImpl
extends ResourceImpl {
    private String _expectedLocalePrefix;
    private ExtendedResourceMeta _extendedResourceMeta;
    private ExtendedDefaultResourceHandlerSupport _extendedDefaultResourceHandlerSupport;

    public ExtendedResourceImpl(ExtendedResourceMeta resourceMeta, ResourceLoader resourceLoader, ExtendedDefaultResourceHandlerSupport support, String contentType, String expectedLocalePrefix, String expectedLibraryName) {
        super(resourceMeta, resourceLoader, support, contentType);
        this._extendedResourceMeta = resourceMeta;
        this._expectedLocalePrefix = expectedLocalePrefix;
        this._extendedDefaultResourceHandlerSupport = support;
        if (expectedLibraryName != null) {
            this.setLibraryName(expectedLibraryName);
        }
    }

    public String getRequestPath() {
        String mapping = this.getResourceHandlerSupport().getMapping() != null ? this.getResourceHandlerSupport().getMapping() : "";
        Library library = this.getExtendedDefaultResourceHandlerSupport().getMyFacesResourcesConfig().getLibrary(this.getLibraryName());
        if (library.getRequestPath() == null) {
            String localePrefix;
            String string = localePrefix = this.getResourceMeta().getLocalePrefix() != null ? this.getResourceMeta().getLocalePrefix() : this._expectedLocalePrefix;
            if (localePrefix == null) {
                localePrefix = ExtendedResourceImpl.getRequestLocalePrefix();
            }
            String path = null;
            path = !this.getResourceHandlerSupport().isExtensionMapping() ? mapping + this.getResourceHandlerSupport().getResourceIdentifier() + "/$/" + localePrefix + '/' + this.getLibraryName() + '/' + this.getResourceName() : this.getResourceHandlerSupport().getResourceIdentifier() + "/$/" + localePrefix + '/' + this.getLibraryName() + '/' + this.getResourceName() + mapping;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, path);
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getViewHandler().getResourceURL(facesContext, this.calculateRequestPath(facesContext, library.getRequestPath()));
    }

    public String getLocalePrefix() {
        String localePrefix;
        String string = localePrefix = this.getResourceMeta().getLocalePrefix() != null ? this.getResourceMeta().getLocalePrefix() : this._expectedLocalePrefix;
        if (localePrefix == null) {
            localePrefix = ExtendedResourceImpl.getRequestLocalePrefix();
        }
        return localePrefix;
    }

    private String calculateRequestPath(FacesContext context, String expression) {
        ValueExpression requestPath = this.getExtendedResourceMeta().getRequestPathExpression();
        if (requestPath == null) {
            ELContextWrapper elContext = new ELContextWrapper(context.getELContext(), context, this);
            requestPath = context.getApplication().getExpressionFactory().createValueExpression((ELContext)elContext, expression, String.class);
            this.getExtendedResourceMeta().setRequestPathExpression(requestPath);
        }
        return (String)requestPath.getValue(context.getELContext());
    }

    protected ExtendedResourceMeta getExtendedResourceMeta() {
        return this._extendedResourceMeta;
    }

    protected ExtendedDefaultResourceHandlerSupport getExtendedDefaultResourceHandlerSupport() {
        return this._extendedDefaultResourceHandlerSupport;
    }

    private static String getRequestLocalePrefix() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Locale locale = null;
        if (!facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext)) {
            locale = facesContext.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            String localePrefix = (String)facesContext.getAttributes().get("org.apache.myfaces.commons.RESOURCE_LOCALE");
            if (localePrefix != null) {
                if (!ResourceValidationUtils.isValidLocalePrefix(localePrefix)) {
                    return null;
                }
                return localePrefix;
            }
        }
        if (locale == null) {
            return null;
        }
        return locale.toString();
    }

    private static class VariableMapperWrapper
    extends VariableMapper {
        private VariableMapper delegate;
        private Map<String, ValueExpression> map;

        private VariableMapperWrapper(VariableMapper delegate, FacesContext context, ExtendedResourceImpl resource) {
            this.delegate = delegate;
            this.map = new HashMap<String, ValueExpression>(4, 1.0f);
            this.map.put("localePrefix", context.getApplication().getExpressionFactory().createValueExpression((Object)resource.getLocalePrefix(), String.class));
            this.map.put("libraryName", context.getApplication().getExpressionFactory().createValueExpression((Object)resource.getLibraryName(), String.class));
            this.map.put("resourceName", context.getApplication().getExpressionFactory().createValueExpression((Object)resource.getResourceName(), String.class));
            this.map.put("mapping", context.getApplication().getExpressionFactory().createValueExpression((Object)resource.getExtendedDefaultResourceHandlerSupport().getMapping(), String.class));
            this.map.put("extensionMapping", context.getApplication().getExpressionFactory().createValueExpression((Object)resource.getExtendedDefaultResourceHandlerSupport().isExtensionMapping(), Boolean.class));
        }

        public ValueExpression resolveVariable(String variable) {
            ValueExpression value = this.map.get(variable);
            if (value != null) {
                return value;
            }
            if (this.delegate != null) {
                return this.delegate.resolveVariable(variable);
            }
            return null;
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (this.delegate != null) {
                return this.delegate.setVariable(variable, expression);
            }
            return null;
        }
    }

    private static class ELContextWrapper
    extends ELContext {
        private ELContext _delegate;
        private VariableMapper _mapper;

        private ELContextWrapper(ELContext delegate, FacesContext context, ExtendedResourceImpl resource) {
            this._delegate = delegate;
            this._mapper = new VariableMapperWrapper(delegate.getVariableMapper(), context, resource);
        }

        public void setPropertyResolved(boolean resolved) {
            this._delegate.setPropertyResolved(resolved);
        }

        public boolean isPropertyResolved() {
            return this._delegate.isPropertyResolved();
        }

        public void putContext(Class key, Object contextObject) {
            this._delegate.putContext(key, contextObject);
        }

        public Object getContext(Class key) {
            return this._delegate.getContext(key);
        }

        public ELResolver getELResolver() {
            return this._delegate.getELResolver();
        }

        public FunctionMapper getFunctionMapper() {
            return this._delegate.getFunctionMapper();
        }

        public Locale getLocale() {
            return this._delegate.getLocale();
        }

        public void setLocale(Locale locale) {
            this._delegate.setLocale(locale);
        }

        public VariableMapper getVariableMapper() {
            return this._mapper;
        }
    }
}

