/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.resourcehandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.commons.resourcehandler.ExtendedDefaultResourceHandlerSupport;
import org.apache.myfaces.commons.resourcehandler.ExtendedResourceImpl;
import org.apache.myfaces.commons.resourcehandler.ExtendedResourceMeta;
import org.apache.myfaces.commons.resourcehandler.config.element.Library;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceHandlerCache;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceLoader;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceValidationUtils;
import org.apache.myfaces.commons.util.ClassUtils;
import org.apache.myfaces.commons.util.ExternalContextUtils;
import org.apache.myfaces.commons.util.RequestType;
import org.apache.myfaces.commons.util.StringUtils;

public class ExtendedResourceHandlerImpl
extends ResourceHandlerWrapper {
    private static final String IS_RESOURCE_REQUEST = "org.apache.myfaces.commons.IS_RESOURCE_REQUEST";
    public static final String RESOURCE_LOCALE = "org.apache.myfaces.commons.RESOURCE_LOCALE";
    private ExtendedDefaultResourceHandlerSupport _resourceHandlerSupport;
    private ResourceHandlerCache _resourceHandlerCache;
    private static final Logger log = Logger.getLogger(ExtendedResourceHandlerImpl.class.getName());
    private static final int _BUFFER_SIZE = 2048;
    private ResourceHandler _delegate;

    public ExtendedResourceHandlerImpl(ResourceHandler delegate) {
        this._delegate = delegate;
        this._resourceHandlerSupport = new ExtendedDefaultResourceHandlerSupport();
    }

    public Resource createResource(String resourceName, String libraryName) {
        if (this.getResourceHandlerSupport().getMyFacesResourcesConfig().getLibrary(libraryName) != null) {
            return this.createResource(resourceName, libraryName, null);
        }
        return super.createResource(resourceName, libraryName);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        if (this.getResourceHandlerSupport().getMyFacesResourcesConfig().getLibrary(libraryName) != null) {
            if (!ResourceValidationUtils.isValidResourceName(resourceName)) {
                return null;
            }
            if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName)) {
                return null;
            }
            return this.defaultCreateResource(resourceName, libraryName, contentType);
        }
        return super.createResource(resourceName, libraryName, contentType);
    }

    private Resource defaultCreateResource(String resourceName, String expectedLibraryName, String contentType) {
        ExtendedResourceImpl resource = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (contentType == null) {
            contentType = facesContext.getExternalContext().getMimeType(resourceName);
        }
        String localePrefix = this.getLocalePrefixForLocateResource();
        String redirectedLibraryName = this.resolveLibraryName(expectedLibraryName);
        if (this.getResourceLoaderCache().containsResource(resourceName, redirectedLibraryName, contentType, localePrefix)) {
            ResourceHandlerCache.ResourceValue resourceValue = this.getResourceLoaderCache().getResource(resourceName, redirectedLibraryName, contentType, localePrefix);
            resource = new ExtendedResourceImpl((ExtendedResourceMeta)resourceValue.getResourceMeta(), resourceValue.getResourceLoader(), this.getResourceHandlerSupport(), contentType, localePrefix, redirectedLibraryName.equals(expectedLibraryName) ? null : expectedLibraryName);
        } else {
            for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                ExtendedResourceMeta resourceMeta = this.deriveResourceMeta(loader, resourceName, redirectedLibraryName, localePrefix);
                if (resourceMeta == null) continue;
                resource = new ExtendedResourceImpl(resourceMeta, loader, this.getResourceHandlerSupport(), contentType, localePrefix, redirectedLibraryName.equals(expectedLibraryName) ? null : expectedLibraryName);
                this.getResourceLoaderCache().putResource(resourceName, redirectedLibraryName, contentType, localePrefix, resourceMeta, loader);
                break;
            }
        }
        return resource;
    }

    public String resolveLibraryName(String libraryName) {
        String finalLibraryName = libraryName;
        Library library = null;
        boolean resolved = false;
        do {
            if ((library = this.getResourceHandlerSupport().getMyFacesResourcesConfig().getLibrary(finalLibraryName)) == null) continue;
            if (library.getRedirectName() != null && library.getRedirectName().length() > 0) {
                finalLibraryName = library.getRedirectName();
                continue;
            }
            resolved = true;
        } while (library != null && !resolved);
        return finalLibraryName;
    }

    protected ExtendedResourceMeta deriveResourceMeta(ResourceLoader resourceLoader, String resourceName, String libraryName, String localePrefix) {
        String resourceVersion = null;
        String libraryVersion = null;
        ExtendedResourceMeta resourceId = null;
        if (localePrefix != null) {
            if (null != libraryName) {
                String pathToLib = localePrefix + '/' + libraryName;
                libraryVersion = resourceLoader.getLibraryVersion(pathToLib);
                if (null != libraryVersion) {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    String pathToResource = localePrefix + '/' + libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = (ExtendedResourceMeta)resourceLoader.createResourceMeta(localePrefix, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(localePrefix + '/' + resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = (ExtendedResourceMeta)resourceLoader.createResourceMeta(localePrefix, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && !resourceLoader.resourceExists(resourceId)) {
                resourceId = null;
            }
        }
        if (resourceId == null) {
            if (null != libraryName) {
                String pathToResource;
                libraryVersion = resourceLoader.getLibraryVersion(libraryName);
                if (null != libraryVersion) {
                    pathToResource = libraryName + '/' + libraryVersion + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                } else {
                    pathToResource = libraryName + '/' + resourceName;
                    resourceVersion = resourceLoader.getResourceVersion(pathToResource);
                }
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = (ExtendedResourceMeta)resourceLoader.createResourceMeta(null, libraryName, libraryVersion, resourceName, resourceVersion);
                }
            } else {
                resourceVersion = resourceLoader.getResourceVersion(resourceName);
                if (resourceVersion == null || !"INVALID".equals(resourceVersion)) {
                    resourceId = (ExtendedResourceMeta)resourceLoader.createResourceMeta(null, null, null, resourceName, resourceVersion);
                }
            }
            if (resourceId != null && !resourceLoader.resourceExists(resourceId)) {
                resourceId = null;
            }
        }
        return resourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        Resource resource;
        String resourceName;
        String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
        if (resourceBasePath == null) {
            super.handleResourceRequest(facesContext);
            return;
        }
        if (!RequestType.SERVLET.equals((Object)ExternalContextUtils.getRequestType((ExternalContext)facesContext.getExternalContext()))) {
            throw new IllegalStateException("Could not obtain an instance of HttpServletResponse.");
        }
        Object response = facesContext.getExternalContext().getResponse();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletResponse == null) {
            throw new IllegalStateException("Could not obtain an instance of HttpServletResponse.");
        }
        if (this.isResourceIdentifierExcluded(facesContext, resourceBasePath)) {
            httpServletResponse.setStatus(404);
            return;
        }
        String libraryName = null;
        String requestedLocalePrefix = null;
        if (resourceBasePath.startsWith(this.getResourceHandlerSupport().getResourceIdentifier())) {
            resourceName = resourceBasePath.substring(this.getResourceHandlerSupport().getResourceIdentifier().length());
            if (resourceName.startsWith("/$")) {
                int from = 3;
                int to = resourceName.indexOf(47, 3);
                if (to >= 0 && to < resourceName.length()) {
                    requestedLocalePrefix = resourceName.substring(from, to);
                    from = to + 1;
                    if (from < resourceName.length()) {
                        to = resourceName.indexOf(47, from);
                        if (to >= 0 && to < resourceName.length()) {
                            libraryName = resourceName.substring(from, to);
                            resourceName = resourceName.substring(to + 1);
                        } else {
                            libraryName = null;
                            resourceName = null;
                        }
                    } else {
                        libraryName = null;
                        resourceName = null;
                    }
                } else {
                    libraryName = null;
                    resourceName = null;
                }
            } else {
                resourceName = null;
            }
        } else {
            super.handleResourceRequest(facesContext);
            return;
        }
        if (resourceName == null) {
            super.handleResourceRequest(facesContext);
            return;
        }
        if (libraryName == null) {
            super.handleResourceRequest(facesContext);
            return;
        }
        if (libraryName != null && this.getResourceHandlerSupport().getMyFacesResourcesConfig().getLibrary(libraryName) == null) {
            super.handleResourceRequest(facesContext);
            return;
        }
        if (resourceName != null && !ResourceValidationUtils.isValidResourceName(resourceName)) {
            httpServletResponse.setStatus(404);
            return;
        }
        if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName)) {
            httpServletResponse.setStatus(404);
            return;
        }
        if (requestedLocalePrefix != null && !ResourceValidationUtils.isValidLocalePrefix(requestedLocalePrefix)) {
            facesContext.getAttributes().put(RESOURCE_LOCALE, requestedLocalePrefix);
        }
        if ((resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName)) == null) {
            httpServletResponse.setStatus(404);
            return;
        }
        if (!resource.userAgentNeedsUpdate(facesContext)) {
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.setContentType(this._getContentType(resource, facesContext.getExternalContext()));
        Map headers = resource.getResponseHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            httpServletResponse.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            InputStream in = resource.getInputStream();
            ServletOutputStream out = httpServletResponse.getOutputStream();
            byte[] buffer = new byte[2048];
            try {
                int count = ExtendedResourceHandlerImpl.pipeBytes(in, (OutputStream)out, buffer);
                httpServletResponse.setContentLength(count);
            }
            finally {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Error trying to load resource " + resourceName + " with library " + libraryName + " :" + e.getMessage());
            }
            httpServletResponse.setStatus(404);
        }
    }

    private static int pipeBytes(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int length;
        int count = 0;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
            count += length;
        }
        return count;
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        Boolean value = (Boolean)facesContext.getAttributes().get(IS_RESOURCE_REQUEST);
        if (value != null && value.booleanValue()) {
            return value;
        }
        String resourceBasePath = this.getResourceHandlerSupport().calculateResourceBasePath(facesContext);
        if (resourceBasePath != null && resourceBasePath.startsWith(this.getResourceHandlerSupport().getResourceIdentifier())) {
            facesContext.getAttributes().put(IS_RESOURCE_REQUEST, Boolean.TRUE);
            return true;
        }
        value = super.isResourceRequest(facesContext);
        facesContext.getAttributes().put(IS_RESOURCE_REQUEST, value);
        return value;
    }

    protected String getLocalePrefixForLocateResource() {
        String localePrefix = null;
        FacesContext context = FacesContext.getCurrentInstance();
        boolean isResourceRequest = context.getApplication().getResourceHandler().isResourceRequest(context);
        if (isResourceRequest && (localePrefix = (String)context.getAttributes().get(RESOURCE_LOCALE)) != null) {
            if (!ResourceValidationUtils.isValidLocalePrefix(localePrefix)) {
                return null;
            }
            return localePrefix;
        }
        String bundleName = context.getApplication().getMessageBundle();
        if (null != bundleName) {
            Locale locale = null;
            locale = isResourceRequest || context.getViewRoot() == null ? context.getApplication().getViewHandler().calculateLocale(context) : context.getViewRoot().getLocale();
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, ClassUtils.getContextClassLoader());
                if (bundle != null) {
                    localePrefix = bundle.getString("javax.faces.resource.localePrefix");
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return localePrefix;
    }

    protected boolean isResourceIdentifierExcluded(FacesContext context, String resourceIdentifier) {
        String value = context.getExternalContext().getInitParameter("javax.faces.RESOURCE_EXCLUDES");
        if (value == null) {
            value = ".class .jsp .jspx .properties .xhtml";
        }
        String[] extensions = StringUtils.splitShortString((String)value, (char)' ');
        for (int i = 0; i < extensions.length; ++i) {
            if (!resourceIdentifier.endsWith(extensions[i])) continue;
            return true;
        }
        return false;
    }

    public boolean libraryExists(String libraryName) {
        if (this.getResourceHandlerSupport().getMyFacesResourcesConfig().getLibrary(libraryName) != null) {
            String localePrefix = this.getLocalePrefixForLocateResource();
            if (libraryName != null && !ResourceValidationUtils.isValidLibraryName(libraryName)) {
                return false;
            }
            String pathToLib = null;
            if (localePrefix != null) {
                pathToLib = localePrefix + '/' + libraryName;
                for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                    if (!loader.libraryExists(pathToLib)) continue;
                    return true;
                }
            }
            for (ResourceLoader loader : this.getResourceHandlerSupport().getResourceLoaders()) {
                if (!loader.libraryExists(libraryName)) continue;
                return true;
            }
        } else {
            super.libraryExists(libraryName);
        }
        return false;
    }

    public void setResourceHandlerSupport(ExtendedDefaultResourceHandlerSupport resourceHandlerSupport) {
        this._resourceHandlerSupport = resourceHandlerSupport;
    }

    protected ExtendedDefaultResourceHandlerSupport getResourceHandlerSupport() {
        return this._resourceHandlerSupport;
    }

    private ResourceHandlerCache getResourceLoaderCache() {
        if (this._resourceHandlerCache == null) {
            this._resourceHandlerCache = new ResourceHandlerCache();
        }
        return this._resourceHandlerCache;
    }

    private String _getContentType(Resource resource, ExternalContext externalContext) {
        String resourceName;
        String contentType = resource.getContentType();
        if ((contentType == null || contentType.length() == 0) && (resourceName = this.getWrappedResourceName(resource)) != null) {
            contentType = externalContext.getMimeType(resourceName);
        }
        return contentType;
    }

    private String getWrappedResourceName(Resource resource) {
        String resourceName = resource.getResourceName();
        if (resourceName != null) {
            return resourceName;
        }
        if (resource instanceof ResourceWrapper) {
            return this.getWrappedResourceName(((ResourceWrapper)resource).getWrapped());
        }
        return null;
    }

    public ResourceHandler getWrapped() {
        return this._delegate;
    }
}

