/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.resourcehandler;

import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.commons.resourcehandler.ExtendedResourceLoaderWrapper;
import org.apache.myfaces.commons.resourcehandler.application.FacesServletMapping;
import org.apache.myfaces.commons.resourcehandler.config.MyFacesResourceHandlerConfigParser;
import org.apache.myfaces.commons.resourcehandler.config.element.MyFacesResourcesConfig;
import org.apache.myfaces.commons.resourcehandler.resource.BaseResourceHandlerSupport;
import org.apache.myfaces.commons.resourcehandler.resource.ClassLoaderResourceLoader;
import org.apache.myfaces.commons.resourcehandler.resource.ExternalContextResourceLoader;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceLoader;
import org.apache.myfaces.commons.resourcehandler.webapp.config.WebConfigProvider;
import org.apache.myfaces.commons.resourcehandler.webapp.config.WebConfigProviderFactory;
import org.apache.myfaces.commons.resourcehandler.webapp.config.WebRegistration;
import org.apache.myfaces.commons.resourcehandler.webapp.config.element.ServletRegistration;
import org.apache.myfaces.commons.util.ClassUtils;
import org.apache.myfaces.commons.util.WebConfigParamUtils;

public class ExtendedDefaultResourceHandlerSupport
extends BaseResourceHandlerSupport {
    protected static final String CACHED_SERVLET_MAPPING = ExtendedDefaultResourceHandlerSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    @Deprecated
    public static final String INIT_PARAM_GZIP_RESOURCES_ENABLED = "org.apache.myfaces.commons.GZIP_RESOURCES_ENABLED";
    @Deprecated
    public static final String INIT_PARAM_GZIP_RESOURCES_SUFFIX = "org.apache.myfaces.commons.GZIP_RESOURCES_SUFFIX";
    public static final String INIT_PARAM_GZIP_RESOURCES_EXTENSIONS_DEFAULT = ".css .js";
    @Deprecated
    public static final String INIT_PARAM_CACHE_DISK_GZIP_RESOURCES = "org.apache.myfaces.commons.CACHE_DISK_GZIP_RESOURCES";
    public static final String INIT_PARAM_EXTENDED_RESOURCE_IDENTIFIER = "org.apache.myfaces.commons.EXTENDED_RESOURCE_IDENTIFIER";
    private static final String INIT_PARAM_DELEGATE_FACES_SERVLET = "org.apache.myfaces.DELEGATE_FACES_SERVLET";
    private static final Class DELEGATE_FACES_SERVLET_INTERFACE_CLASS = ClassUtils.simpleClassForName((String)"org.apache.myfaces.shared_impl.webapp.webxml.DelegatedFacesServlet");
    private static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private ResourceLoader[] _resourceLoaders;
    private final boolean _developmentStage;
    private MyFacesResourcesConfig _config;
    private WebConfigProvider _webConfigProvider;
    private String _resourceIdentifier;

    public ExtendedDefaultResourceHandlerSupport() {
        FacesContext context = FacesContext.getCurrentInstance();
        this._developmentStage = context.isProjectStage(ProjectStage.Development);
        this._resourceIdentifier = WebConfigParamUtils.getStringInitParameter((ExternalContext)context.getExternalContext(), (String)INIT_PARAM_EXTENDED_RESOURCE_IDENTIFIER, (String)"/javax.faces.resource");
        MyFacesResourceHandlerConfigParser configParser = new MyFacesResourceHandlerConfigParser();
        this._config = configParser.parse(FacesContext.getCurrentInstance());
        this._webConfigProvider = WebConfigProviderFactory.getFacesConfigResourceProviderFactory(context).createWebConfigProvider(context);
        this._webConfigProvider.init(context);
        this.getResourceLoaders();
    }

    public MyFacesResourcesConfig getMyFacesResourcesConfig() {
        return this._config;
    }

    public String calculateResourceBasePath(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String resourceBasePath = null;
        FacesServletMapping mapping = ExtendedDefaultResourceHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
        if (mapping != null) {
            if (mapping.isExtensionMapping()) {
                resourceBasePath = externalContext.getRequestServletPath();
                int stripPoint = resourceBasePath.lastIndexOf(46);
                if (stripPoint > 0) {
                    resourceBasePath = resourceBasePath.substring(0, stripPoint);
                }
            } else {
                resourceBasePath = externalContext.getRequestPathInfo();
            }
            return resourceBasePath;
        }
        return externalContext.getRequestPathInfo();
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            FacesServletMapping calculatedMapping = ExtendedDefaultResourceHandlerSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            if (!calculatedMapping.isPrefixMapping()) {
                this.getWebConfigProvider().update(context);
                WebRegistration webRegistration = this.getWebConfigProvider().getWebRegistration(context);
                String prefix = this.getFacesServletPrefixMapping(context, webRegistration);
                mapping = prefix != null ? FacesServletMapping.createPrefixMapping(prefix) : calculatedMapping;
            } else {
                mapping = calculatedMapping;
            }
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    private String getFacesServletPrefixMapping(FacesContext context, WebRegistration webRegistration) {
        String prefix = null;
        String delegateFacesServlet = WebConfigParamUtils.getStringInitParameter((ExternalContext)context.getExternalContext(), (String)INIT_PARAM_DELEGATE_FACES_SERVLET);
        for (Map.Entry<String, ? extends ServletRegistration> entry : webRegistration.getServletRegistrations().entrySet()) {
            boolean facesServlet;
            ServletRegistration registration;
            block10: {
                registration = entry.getValue();
                facesServlet = false;
                if (FacesServlet.class.getName().equals(registration.getClassName())) {
                    facesServlet = true;
                } else if (delegateFacesServlet != null && delegateFacesServlet.equals(registration.getClassName())) {
                    facesServlet = true;
                } else if (DELEGATE_FACES_SERVLET_INTERFACE_CLASS != null) {
                    try {
                        Class servletClass = ClassUtils.classForName((String)registration.getClassName());
                        if (DELEGATE_FACES_SERVLET_INTERFACE_CLASS.isAssignableFrom(servletClass)) {
                            facesServlet = true;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Log log = LogFactory.getLog(ExtendedDefaultResourceHandlerSupport.class);
                        if (!log.isTraceEnabled()) break block10;
                        log.trace((Object)"cannot load servlet class to detect if is a FacesServlet or DelegateFacesServlet", (Throwable)e);
                    }
                }
            }
            if (!facesServlet) continue;
            for (String urlPattern : registration.getMappings()) {
                int index;
                String extension;
                String string = extension = urlPattern != null && urlPattern.startsWith("*.") ? urlPattern.substring(urlPattern.indexOf(46)) : null;
                prefix = extension == null ? ((index = urlPattern.indexOf("/*")) != -1 ? urlPattern.substring(0, urlPattern.indexOf("/*")) : urlPattern) : null;
                if (prefix == null) continue;
                return prefix;
            }
        }
        return prefix;
    }

    public ResourceLoader[] getResourceLoaders() {
        if (this._resourceLoaders == null) {
            this._resourceLoaders = new ResourceLoader[]{new ExtendedResourceLoaderWrapper(new ExternalContextResourceLoader("/resources")), new ExtendedResourceLoaderWrapper(new ClassLoaderResourceLoader("META-INF/resources"))};
        }
        return this._resourceLoaders;
    }

    public WebConfigProvider getWebConfigProvider() {
        return this._webConfigProvider;
    }

    public String getResourceIdentifier() {
        return this._resourceIdentifier;
    }
}

