<%@ page session="false" contentType="text/html;charset=utf-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/commons/converters" prefix="mcc" %>
<%@ taglib uri="http://myfaces.apache.org/commons/validators" prefix="mcv" %>

<html>
<f:view>

<%@include file="inc/head.inc" %>

<!--
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
//-->

<body>
<div id="container">
   <f:loadBundle basename="org.apache.myfaces.examples.resource.example_messages" var="example_messages"/>

   <h1><h:outputText value="#{example_messages['title']}"/></h1>
   <br/>

<!--
managed beans used:
    validateForm
-->


    <h:panelGroup id="body">

	<h:form id="form1">
		<h:panelGrid columns="3">
					
			<h:outputLabel for="url" value="#{example_messages['validate_url']}" />
			<h:inputText id="url" value="#{validateForm.url}" required="true">
				<mcv:validateUrl schemes="http,https" allow2Slashes="true"/>
			</h:inputText>
			<h:message id="urlError" for="url" styleClass="error" />
			
			<h:panelGroup/>
			<h:commandButton id="validateButton" value="#{example_messages['button_submit']}" action="#{validateForm.submit}"/>
			<h:panelGroup/>
		
		</h:panelGrid>
	</h:form>

    </h:panelGroup>


<%@include file="inc/page_footer.jsp" %>
</div>
</body>
</f:view>
</html>
