<%@ page session="false" contentType="text/html;charset=utf-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/commons/converters"
    prefix="mcc"%>
<%@ taglib uri="http://myfaces.apache.org/commons/components"
    prefix="mc"%>
<%@ taglib uri="http://myfaces.apache.org/commons/validators"
    prefix="mcv"%>

<html>
<f:view>

<%@include file="inc/head.inc"%>

<!--
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
//-->

<body>
<div id="container">
    <f:loadBundle
        basename="org.apache.myfaces.examples.resource.example_messages"
        var="example_messages" />

   <h1><h:outputText value="#{example_messages['title']}"/></h1>
   <br/>
    <h:form>
    	<p>This component allows to export the datatable contents to an excel or pdf file.</p>
		
		<br>
		
		<h:dataTable id="tbl_cars"
                styleClass="scrollerTable"
                headerClass="standardTable_Header"
                footerClass="standardTable_Header"
                rowClasses="standardTable_Row1,standardTable_Row2"
                columnClasses="standardTable_Column,standardTable_ColumnCentered,standardTable_Column"
                var="car"
                value="#{exporterBean.carsList}">
           <h:column>
               <f:facet name="header">
                   <h:outputText value="Id" />
               </f:facet>
               <h:outputText value="#{car.id}" />
           </h:column>

           <h:column>
               <f:facet name="header">
                  <h:outputText value="Type" />
               </f:facet>
               <h:outputText value="#{car.type}" />
           </h:column>

           <h:column>
               <f:facet name="header">
                  <h:outputText value="Color" />
               </f:facet>
               <h:outputText value="#{car.color}" />
           </h:column>

        </h:dataTable>
        
		<br>
		
		<h:commandButton action="#{exporterBean.export}" value="Export as excel">
			<mc:exporterActionListener for="tbl_cars" fileType="XLS" filename="excel"/>
		</h:commandButton>			
		
		<br>
		
		<h:commandButton action="#{exporterBean.export}" value="Export as pdf">
			<mc:exporterActionListener for="tbl_cars" fileType="PDF" filename="pdf"/>
		</h:commandButton>
			
		
    </h:form>


<%@ include file="inc/page_footer.jsp" %>
</div>
</body>
</f:view>
</html>
