/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.examples;

import java.util.Date;

import javax.faces.component.UISelectOne;

public class DateTimeBean
{
    private String type;
    
    private Date date1;
    
    private Date date2;
    
    private UISelectOne typeSelect;
    
    public DateTimeBean()
    {
        date1 = new Date();
        type = "both";
    }
    
    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public Date getDate1()
    {
        return date1;
    }

    public void setDate1(Date date1)
    {
        this.date1 = date1;
    }
    
    public Date getDate2()
    {
        return date2;
    }

    public void setDate2(Date date2)
    {
        this.date2 = date2;
    }
    
    public String[] getInvalidMonths()
    {
        return new String[]{"jan", "apr", "sep"};
    }

    public String submit()
    {
        System.out.println("Action was called.");
        return ("valid");        
    }
    
    public String getTypeFromSelect()
    {
        Object value = typeSelect.getValue();
        if (value != null)
        {
            return value.toString();
        }
        return null;
    }

    public UISelectOne getTypeSelect()
    {
        return typeSelect;
    }

    public void setTypeSelect(UISelectOne typeSelect)
    {
        this.typeSelect = typeSelect;
    }
}
