<%@ page session="false" contentType="text/html;charset=utf-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/commons/converters"
    prefix="mcc"%>
<%@ taglib uri="http://myfaces.apache.org/commons/components"
    prefix="mc"%>
<%@ taglib uri="http://myfaces.apache.org/commons/validators"
    prefix="mcv"%>

<html>
<f:view>

<%@include file="inc/head.inc"%>

<!--
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
//-->

<body>
<div id="container">
    <f:loadBundle
        basename="org.apache.myfaces.examples.resource.example_messages"
        var="example_messages" />

   <h1><h:outputText value="#{example_messages['title']}"/></h1>
   <br/>
        <h:messages showDetail="true" showSummary="false"/>
        
        <h:form id="myform">
            <p>Some valid test numbers</p>
            
            <ul>
              <li>Mastercard : 5555555555554444</li>
              <li>Mastercard : 5105105105105100</li>
              <li>Visa : 4111111111111111</li>
              <li>Visa : 4111111111111111</li>
              <li>Discover : 6011111111111117</li>
              <li>Discover : 6011000990139424</li>
              <li>American Express : 378282246310005</li>
              <li>American Express : 371449635398431</li>
            </ul>
            
            <h:panelGrid columns ="3">
              <h:outputLabel for="creditCardType" value="#{example_messages['credit_type']}" />
              <h:selectOneRadio id="creditCardType" value="#{validateCreditCard.creditCardType}" immediate="true" binding="#{validateCreditCard.creditCardTypeSelect}">
                  <f:selectItems value="#{validateCreditCard.creditCardTypes}"/>
              </h:selectOneRadio>
              <h:message id="creditCardTypeError" for="creditCardType" styleClass="error" />
              
              <h:outputLabel for="creditCardNumber" value="#{example_messages['credit_number']}" />
              <h:inputText id="creditCardNumber" value="#{validateCreditCard.creditCardNumber}" required="true">
                  <mcv:validateCreditCard 
                      amex="#{validateCreditCard.creditCardTypeFromSelect == 'AMEX'}"
                      visa="#{validateCreditCard.creditCardTypeFromSelect == 'VISA'}"
                      discover="#{validateCreditCard.creditCardTypeFromSelect == 'DISCOVER'}"
                      mastercard="#{validateCreditCard.creditCardTypeFromSelect == 'MASTERCARD'}" />
              </h:inputText>
              <h:message id="creditCardNumberError" for="creditCardNumber" styleClass="error" />
            </h:panelGrid>
            <h:panelGroup/>
            <h:commandButton id="validateButton" value="#{example_messages['button_submit']}" action="#{validateCreditCard.submit}"/>
            <h:panelGroup/>
        </h:form>     
<%@include file="inc/page_footer.jsp"%>
</div>
</body>

</f:view>
</html>