<%@ page session="false" contentType="text/html;charset=utf-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/commons/converters"
    prefix="mcc"%>
<%@ taglib uri="http://myfaces.apache.org/commons/components"
    prefix="mc"%>
<%@ taglib uri="http://myfaces.apache.org/commons/validators"
    prefix="mcv"%>

<html>
<f:view>

<%@include file="inc/head.inc"%>

<!--
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
//-->

<body>
<div id="container">
    <f:loadBundle
        basename="org.apache.myfaces.examples.resource.example_messages"
        var="example_messages" />

   <h1><h:outputText value="#{example_messages['title']}"/></h1>
   <br/>
	<h:panelGroup id="body">
        <p>This example check how mcc:convertBoolean works. This converter 
        translates between boolean values (true/false)
        and alternate versions of those boolean values like
        (yes/no), (1/0), and (way/no way).</p>
		<h:form id="form1">
		    <h:messages showDetail="false" showSummary="true" ></h:messages>
            <p>Current value: <h:outputText value="#{booleanBean.way}"/></p>
			<h:panelGrid columns="3">

				<h:outputLabel for="boolVal" value="" />
				<h:inputText id="boolVal" value="#{booleanBean.way}" required="true">
					<mcc:convertBoolean trueValue="way" falseValue="no way" />
				</h:inputText>
				<h:message for="boolVal" styleClass="error" />

				<h:panelGroup />
				<h:commandButton id="validateButton"
					value="#{example_messages['button_submit']}"
					action="#{booleanBean.submit}" />
				<h:panelGroup />

			</h:panelGrid>
		</h:form>

	</h:panelGroup>
<%@include file="inc/page_footer.jsp"%>
</div>
</body>

</f:view>
</html>