/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.exporter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author cagatay (latest modification by $Author: skitching $)
 * @version $Revision: 673833 $ $Date: 2008-07-03 23:58:05 +0200 (Thu, 03 Jul 2008) $
 */
public class ExporterBean implements Serializable {

    private List carsList;

    public List getCarsList() {
        if( carsList == null)
            carsList = createCarsList();
        return carsList;
    }

    public void setCarsList(List carsList) {
        this.carsList = carsList;
    }
    
    private List createCarsList() {
        List list  = new ArrayList();
        
        for(int i = 0; i < 10; ++i) {
            list.add( new SimpleCar(i, "row" + i, "value" + i));
        }
        return list;
    }
    
    public String export() {
        return null;
    }
}
