/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.examples.validate;

import java.util.ArrayList;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/**
 * @author mwessendorf
 * @version $Revision: 673801 $ $Date: 2008-07-03 22:58:48 +0200 (Thu, 03 Jul 2008) $
 */
public class ValidateCreditCard {

    private String creditCardNumber = null;
    
    private String creditCardType = "MASTERCARD";
    
    private List<SelectItem> types = null;
    
    private UISelectOne creditCardTypeSelect;
    
    public List<SelectItem> getCreditCardTypes()
    {
        if (types == null)
        {
            types = new ArrayList<SelectItem>();
            types.add(new SelectItem("MASTERCARD"));
            types.add(new SelectItem("VISA"));
            types.add(new SelectItem("DISCOVER"));
            types.add(new SelectItem("AMEX"));
        }
        return types;
    }
    
    public String submit(){
        System.out.println("Action was called.");
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("The selected credit card type/number is valid"));
        return ("valid");
    }

    public String getCreditCardNumber() {
        return creditCardNumber;
    }

    public void setCreditCardNumber(String string) {
        creditCardNumber = string;
    }

    public String getCreditCardType()
    {
        return creditCardType;
    }

    public void setCreditCardType(String creditCardType)
    {
        this.creditCardType = creditCardType;
    }
    
    public boolean isAmex()
    {
        return "AMEX".equalsIgnoreCase(creditCardType);
    }

    public boolean isVisa()
    {
        return "VISA".equalsIgnoreCase(creditCardType);
    }
    
    public boolean isMastercard()
    {
        return "MASTERCARD".equalsIgnoreCase(creditCardType);
    }
    
    public boolean isDiscover()
    {
        return "DISCOVER".equalsIgnoreCase(creditCardType);
    }

    public UISelectOne getCreditCardTypeSelect()
    {
        return creditCardTypeSelect;
    }

    public void setCreditCardTypeSelect(UISelectOne creditCardTypeSelect)
    {
        this.creditCardTypeSelect = creditCardTypeSelect;
    }
    
    public String getCreditCardTypeFromSelect()
    {
        Object value = creditCardTypeSelect.getValue();
        if (value != null)
        {
            return value.toString();
        }
        return null;
    }
}
