/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.examples;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UISelectOne;

public class NumberBean
{
    private String type;
    
    private Map<String, Double> numberMap;
    
    private UISelectOne typeSelect;
    
    public NumberBean()
    {
        numberMap = new HashMap<String, Double>();
        numberMap.put("number1", 0.5d);
        type = "percent";
    }

    public Map<String, Double> getNumberMap()
    {
        return numberMap;
    }

    public void setNumberMap(Map<String, Double> numberMap)
    {
        this.numberMap = numberMap;
    }

    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }
    
    public String submit()
    {
        System.out.println("Action was called.");
        return ("valid");        
    }
    
    public String getTypeFromSelect()
    {
        Object value = typeSelect.getValue();
        if (value != null)
        {
            return value.toString();
        }
        return null;
    }

    public UISelectOne getTypeSelect()
    {
        return typeSelect;
    }

    public void setTypeSelect(UISelectOne typeSelect)
    {
        this.typeSelect = typeSelect;
    }
}
