/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.spring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringResource
implements Resource {
    private static final Logger logger = LoggerFactory.getLogger(SpringResource.class);
    private final org.springframework.core.io.Resource _resource;

    public SpringResource(org.springframework.core.io.Resource resource) {
        this._resource = resource;
    }

    public void append(Action<OutputStream> arg0) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public long getLastModified() {
        try {
            return this._resource.lastModified();
        }
        catch (IOException e) {
            logger.warn("Failed to get last modified date of resource: " + this._resource, (Throwable)e);
            return -1L;
        }
    }

    public String getName() {
        return this._resource.getFilename();
    }

    public String getQualifiedPath() {
        try {
            return this._resource.getURI().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get URI of resource: " + this._resource, e);
        }
    }

    public long getSize() {
        try {
            return this._resource.contentLength();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get content length of resource: " + this._resource, e);
        }
    }

    public boolean isExists() {
        return this._resource.exists();
    }

    public boolean isReadOnly() {
        return true;
    }

    public InputStream read() throws ResourceException {
        try {
            return this._resource.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get input stream of resource: " + this._resource, e);
        }
    }

    public void read(Action<InputStream> action) throws ResourceException {
        InputStream in = this.read();
        try {
            action.run((Object)in);
        }
        catch (Exception e) {
            try {
                throw new ResourceException((Resource)this, "Error occurred in read callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{in});
    }

    public <E> E read(Func<InputStream, E> func) throws ResourceException {
        Object object;
        InputStream in = this.read();
        try {
            object = func.eval((Object)in);
        }
        catch (Exception e) {
            try {
                throw new ResourceException((Resource)this, "Error occurred in read callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{in});
        return (E)object;
    }

    public void write(Action<OutputStream> arg0) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public org.springframework.core.io.Resource getResource() {
        return this._resource;
    }
}

