/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch;

import java.util.HashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.elasticsearch.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.ElasticSearchUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchInsertBuilder
extends AbstractRowInsertionBuilder<ElasticSearchUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchInsertBuilder.class);

    public ElasticSearchInsertBuilder(ElasticSearchUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        ElasticSearchDataContext dataContext = ((ElasticSearchUpdateCallback)this.getUpdateCallback()).getDataContext();
        Client client = dataContext.getElasticSearchClient();
        String indexName = dataContext.getIndexName();
        String documentType = this.getTable().getName();
        IndexRequestBuilder requestBuilder = new IndexRequestBuilder(client, indexName).setType(documentType);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isSet(columns[i])) continue;
            String name = columns[i].getName();
            Object value = values[i];
            if ("_id".equals(name)) {
                if (value == null) continue;
                requestBuilder.setId(value.toString());
                continue;
            }
            valueMap.put(name, value);
        }
        assert (!valueMap.isEmpty());
        requestBuilder.setSource(valueMap);
        requestBuilder.setCreate(true);
        IndexResponse result = (IndexResponse)requestBuilder.execute().actionGet();
        logger.debug("Inserted document: id={}", (Object)result.getId());
    }
}

