/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestCreateTableBuilder;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDeleteBuilder;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestInsertBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchRestUpdateCallback
extends AbstractUpdateCallback {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestUpdateCallback.class);
    private static final int BULK_BUFFER_SIZE = 1000;
    private BulkRequest bulkRequest;
    private int bulkActionCount = 0;
    private final boolean isBatch;

    public ElasticSearchRestUpdateCallback(ElasticSearchRestDataContext dataContext, boolean isBatch) {
        super((DataContext)dataContext);
        this.isBatch = isBatch;
    }

    private boolean isBatch() {
        return this.isBatch;
    }

    public ElasticSearchRestDataContext getDataContext() {
        return (ElasticSearchRestDataContext)super.getDataContext();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new ElasticSearchRestCreateTableBuilder(this, schema, name);
    }

    public boolean isDropTableSupported() {
        return false;
    }

    public TableDropBuilder dropTable(Table table) {
        throw new UnsupportedOperationException();
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new ElasticSearchRestInsertBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new ElasticSearchRestDeleteBuilder(this, table);
    }

    public void onExecuteUpdateFinished() {
        if (this.isBatch()) {
            this.flushBulkActions();
        }
        this.getDataContext().refreshSchemas();
    }

    private void flushBulkActions() {
        if (this.bulkRequest == null || this.bulkActionCount == 0) {
            return;
        }
        logger.info("Flushing {} actions to ElasticSearch index {}", (Object)this.bulkActionCount, (Object)this.getDataContext().getIndexName());
        this.executeBlocking((ActionRequest)this.bulkRequest);
        this.bulkActionCount = 0;
        this.bulkRequest = null;
    }

    public void execute(ActionRequest action) {
        if (this.isBatch() && action instanceof DocWriteRequest) {
            this.getBulkRequest().add((DocWriteRequest)action);
            ++this.bulkActionCount;
            if (this.bulkActionCount == 1000) {
                this.flushBulkActions();
            }
        } else {
            this.executeBlocking(action);
        }
    }

    private void executeBlocking(ActionRequest action) {
        try {
            if (action instanceof PutMappingRequest) {
                this.getDataContext().getElasticSearchClient().createMapping((PutMappingRequest)action, new Header[0]);
            } else {
                ActionResponse result = this.getDataContext().getElasticSearchClient().execute(action);
                if (result instanceof BulkResponse && ((BulkResponse)result).hasFailures()) {
                    BulkItemResponse[] failedItems = ((BulkResponse)result).getItems();
                    for (int i = 0; i < failedItems.length; ++i) {
                        if (!failedItems[i].isFailed()) continue;
                        BulkItemResponse failedItem = failedItems[i];
                        logger.error("Bulk failed with item no. {} of {}: id={} op={} status={} error={}", new Object[]{i + 1, failedItems.length, failedItem.getId(), failedItem.getOpType(), failedItem.status(), failedItem.getFailureMessage()});
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("Could not execute command {} ", (Object)action, (Object)e);
            throw new MetaModelException("Could not execute " + action, (Exception)e);
        }
    }

    private BulkRequest getBulkRequest() {
        if (this.bulkRequest == null) {
            this.bulkRequest = new BulkRequest();
        }
        return this.bulkRequest;
    }
}

