/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.util.HashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.index.IndexRequest;

final class ElasticSearchRestInsertBuilder
extends AbstractRowInsertionBuilder<ElasticSearchRestUpdateCallback> {
    public ElasticSearchRestInsertBuilder(ElasticSearchRestUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        ElasticSearchRestUpdateCallback updateCallback = (ElasticSearchRestUpdateCallback)this.getUpdateCallback();
        ElasticSearchRestDataContext dataContext = updateCallback.getDataContext();
        String indexName = dataContext.getIndexName();
        String documentType = this.getTable().getName();
        HashMap<String, Object> source = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        String id = null;
        for (int i = 0; i < columns.length; ++i) {
            if (!this.isSet(columns[i])) continue;
            String columnName = columns[i].getName();
            Object value = values[i];
            if ("_id".equals(columnName)) {
                if (value == null) continue;
                id = value.toString();
                continue;
            }
            String fieldName = ElasticSearchUtils.getValidatedFieldName((String)columnName);
            source.put(fieldName, value);
        }
        assert (!source.isEmpty());
        IndexRequest indexRequest = new IndexRequest(indexName, documentType, id);
        indexRequest.source(source);
        ((ElasticSearchRestUpdateCallback)this.getUpdateCallback()).execute((ActionRequest)indexRequest);
    }
}

