/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

final class ElasticSearchRestDeleteBuilder
extends AbstractRowDeletionBuilder {
    private final ElasticSearchRestUpdateCallback _updateCallback;

    public ElasticSearchRestDeleteBuilder(ElasticSearchRestUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        Table table = this.getTable();
        String documentType = table.getName();
        ElasticSearchRestDataContext dataContext = this._updateCallback.getDataContext();
        String indexName = dataContext.getIndexName();
        List whereItems = this.getWhereItems();
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere((List)whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder == null) {
            throw new UnsupportedOperationException("Could not push down WHERE items to delete by query request: " + whereItems);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.types(new String[]{documentType});
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse response = dataContext.getElasticSearchClient().search(searchRequest, new Header[0]);
            for (SearchHit hit : response.getHits()) {
                String typeId = hit.getId();
                DeleteRequest deleteRequest = new DeleteRequest(indexName, documentType, typeId);
                this._updateCallback.execute((ActionRequest)deleteRequest);
            }
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }
}

