/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.metamodel.elasticsearch.AbstractElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.AbstractElasticSearchDataSet;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestClient;
import org.apache.metamodel.query.SelectItem;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticSearchRestDataSet
extends AbstractElasticSearchDataSet {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestDataSet.class);
    private final ElasticSearchRestClient _client;

    public ElasticSearchRestDataSet(ElasticSearchRestClient client, SearchResponse searchResponse, List<SelectItem> selectItems) {
        super(searchResponse, selectItems);
        this._client = client;
    }

    public void closeNow() {
        String scrollId = this._searchResponse.getScrollId();
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        try {
            this._client.execute((ActionRequest)clearScrollRequest);
        }
        catch (IOException e) {
            logger.warn("Could not clear scroll.", (Throwable)e);
        }
    }

    protected SearchResponse scrollSearchResponse(String scrollId) throws IOException {
        return this._client.searchScroll(new SearchScrollRequest(scrollId).scroll(AbstractElasticSearchDataContext.TIMEOUT_SCROLL), new Header[0]);
    }
}

