/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestClient;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticSearchRestDataContextFactory
implements DataContextFactory {
    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        switch (properties.getDataContextType()) {
            case "elasticsearch": {
                String url = properties.getUrl();
                return url != null && url.startsWith("http") && this.acceptsInternal(properties);
            }
            case "es-rest": 
            case "elasticsearch-rest": {
                return this.acceptsInternal(properties);
            }
        }
        return false;
    }

    private boolean acceptsInternal(DataContextProperties properties) {
        if (properties.getUrl() == null) {
            return false;
        }
        return this.getIndex(properties) != null;
    }

    private ElasticSearchRestClient createClient(DataContextProperties properties) throws MalformedURLException {
        URL url = new URL(properties.getUrl());
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(url.getHost(), url.getPort())});
        if (properties.getUsername() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(properties.getUsername(), properties.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchRestDataContextFactory.lambda$createClient$0((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new ElasticSearchRestClient(builder.build());
    }

    private String getIndex(DataContextProperties properties) {
        String databaseName = properties.getDatabaseName();
        if (databaseName == null) {
            properties.toMap().get("index");
        }
        return databaseName;
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        try {
            ElasticSearchRestClient client = this.createClient(properties);
            String indexName = this.getIndex(properties);
            SimpleTableDef[] tableDefinitions = properties.getTableDefs();
            return new ElasticSearchRestDataContext(client, indexName, tableDefinitions);
        }
        catch (MalformedURLException e) {
            throw new UnsupportedDataContextPropertiesException((Exception)e);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

