/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.metamodel.BatchUpdateScript;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.AbstractElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestClient;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataSet;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestDataContext
extends AbstractElasticSearchDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestDataContext.class);
    private static final int SCROLL_THRESHOLD = 400;
    private final ElasticSearchRestClient elasticSearchClient;

    public ElasticSearchRestDataContext(ElasticSearchRestClient client, String indexName, SimpleTableDef ... tableDefinitions) {
        super(indexName, tableDefinitions);
        if (client == null) {
            throw new IllegalArgumentException("ElasticSearch Client cannot be null");
        }
        this.elasticSearchClient = client;
        this.dynamicTableDefinitions.addAll(Arrays.asList(this.detectSchema()));
    }

    public ElasticSearchRestDataContext(ElasticSearchRestClient client, String indexName) {
        this(client, indexName, new SimpleTableDef[0]);
    }

    protected SimpleTableDef[] detectSchema() {
        Set<Map.Entry<String, Object>> mappings;
        logger.info("Detecting schema for index '{}'", (Object)this.indexName);
        try {
            mappings = this.getElasticSearchClient().getMappings(this.indexName, new Header[0]);
        }
        catch (IOException e) {
            logger.error("Failed to retrieve mappings", (Throwable)e);
            throw new MetaModelException("Failed to execute request for index information needed to detect schema", (Exception)e);
        }
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        if (mappings.isEmpty()) {
            logger.warn("No metadata returned for index name '{}' - no tables will be detected.");
        } else {
            for (Map.Entry<String, Object> mapping : mappings) {
                String documentType = mapping.getKey();
                Map mappingConfiguration = (Map)mapping.getValue();
                Map properties = (Map)mappingConfiguration.get("properties");
                try {
                    SimpleTableDef table = ElasticSearchRestDataContext.detectTable(properties, documentType);
                    result.add(table);
                }
                catch (Exception e) {
                    logger.error("Unexpected error during detectTable for document type '{}'", (Object)documentType, (Object)e);
                }
            }
        }
        return ElasticSearchRestDataContext.sortTables(result);
    }

    protected void onSchemaCacheRefreshed() {
        this.getElasticSearchClient().refresh(this.indexName, new Header[0]);
        this.detectSchema();
    }

    private static SimpleTableDef detectTable(Map<String, Object> metadataProperties, String documentType) {
        ElasticSearchMetaData metaData = ElasticSearchMetaDataParser.parse(metadataProperties);
        return new SimpleTableDef(documentType, metaData.getColumnNames(), metaData.getColumnTypes());
    }

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder != null) {
            SearchSourceBuilder searchSourceBuilder = this.createSearchRequest(firstRow, maxRows, queryBuilder);
            SearchResponse result = this.executeSearch(table, searchSourceBuilder, this.scrollNeeded(maxRows));
            return new ElasticSearchRestDataSet(this.getElasticSearchClient(), result, selectItems);
        }
        return super.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
    }

    private boolean scrollNeeded(int maxRows) {
        return !this.limitMaxRowsIsSet(maxRows) || maxRows > 400;
    }

    private SearchResponse executeSearch(Table table, SearchSourceBuilder searchSourceBuilder, boolean scroll) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName()}, searchSourceBuilder).types(new String[]{table.getName()});
        if (scroll) {
            searchRequest.scroll(TIMEOUT_SCROLL);
        }
        try {
            return this.getElasticSearchClient().search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            logger.warn("Could not execute ElasticSearch query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch query", (Exception)e);
        }
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        SearchResponse searchResult = this.executeSearch(table, this.createSearchRequest(1, maxRows, null), this.scrollNeeded(maxRows));
        return new ElasticSearchRestDataSet(this.getElasticSearchClient(), searchResult, columns.stream().map(SelectItem::new).collect(Collectors.toList()));
    }

    private SearchSourceBuilder createSearchRequest(int firstRow, int maxRows, QueryBuilder queryBuilder) {
        SearchSourceBuilder searchRequest = new SearchSourceBuilder();
        if (firstRow > 1) {
            int zeroBasedFrom = firstRow - 1;
            searchRequest.from(zeroBasedFrom);
        }
        if (this.limitMaxRowsIsSet(maxRows)) {
            searchRequest.size(maxRows);
        } else {
            searchRequest.size(400);
        }
        if (queryBuilder != null) {
            searchRequest.query(queryBuilder);
        }
        return searchRequest;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        if (keyValue == null) {
            return null;
        }
        String documentType = table.getName();
        String id = keyValue.toString();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        try {
            return ElasticSearchUtils.createRow((Map)this.getElasticSearchClient().get(new GetRequest(this.getIndexName(), documentType, id), new Header[0]).getSource(), (String)id, (DataSetHeader)header);
        }
        catch (IOException e) {
            logger.warn("Could not execute ElasticSearch query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch query", (Exception)e);
        }
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)documentType));
        sourceBuilder.size(0);
        try {
            return this.getElasticSearchClient().search(new SearchRequest(new String[]{this.getIndexName()}, sourceBuilder), new Header[0]).getHits().getTotalHits();
        }
        catch (Exception e) {
            logger.warn("Could not execute ElasticSearch get query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch get query", e);
        }
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        boolean isBatch = update instanceof BatchUpdateScript;
        ElasticSearchRestUpdateCallback callback = new ElasticSearchRestUpdateCallback(this, isBatch);
        update.run((UpdateCallback)callback);
        callback.onExecuteUpdateFinished();
        return callback.getUpdateSummary();
    }

    public ElasticSearchRestClient getElasticSearchClient() {
        return this.elasticSearchClient;
    }
}

