/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.util.Map;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestUpdateCallback;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;

final class ElasticSearchRestCreateTableBuilder
extends AbstractTableCreationBuilder<ElasticSearchRestUpdateCallback> {
    public ElasticSearchRestCreateTableBuilder(ElasticSearchRestUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() throws MetaModelException {
        MutableTable table = this.getTable();
        Map source = ElasticSearchUtils.getMappingSource((MutableTable)table);
        ElasticSearchRestDataContext dataContext = ((ElasticSearchRestUpdateCallback)this.getUpdateCallback()).getDataContext();
        String indexName = dataContext.getIndexName();
        PutMappingRequest putMapping = new PutMappingRequest(new String[]{indexName}).type(table.getName()).source(source);
        ((ElasticSearchRestUpdateCallback)this.getUpdateCallback()).execute((ActionRequest)putMapping);
        MutableSchema schema = (MutableSchema)this.getSchema();
        schema.addTable((Table)table);
        return table;
    }
}

